/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.AbstractBuildServer;
import ch.inftec.ju.versioverride.BuildServer;
import ch.inftec.ju.versioverride.BuildnumberFile;
import java.io.File;
import java.io.IOException;

public enum BuildServerType {
    BAMBOO(new BambooBuildServer()),
    JENKINS(new JenkinsBuildServer()),
    UNKNOWN(new LocalBuildMachine());

    private BuildServer classifierBuilder;

    private BuildServerType(BuildServer classifierBuilder) {
        this.classifierBuilder = classifierBuilder;
    }

    public BuildServer getBuildServer() {
        return this.classifierBuilder;
    }

    static class LocalBuildMachine
    extends AbstractBuildServer {
        LocalBuildMachine() {
        }

        @Override
        public String getBranchName() {
            return "local";
        }

        @Override
        public String getJobName() {
            return "local";
        }

        @Override
        public String getProductName() {
            return "local";
        }

        @Override
        public String getBuildNumber() throws IOException {
            return this.readFromFile();
        }

        private String readFromFile() throws IOException {
            String buildNumber = "0";
            File buildNumberFile = new File(".buildnumber");
            if (buildNumberFile.exists()) {
                buildNumber = BuildnumberFile.readFirstLine(buildNumberFile);
                buildNumberFile.delete();
            }
            int incrementedBuildNumber = Integer.parseInt(buildNumber) + 1;
            buildNumber = incrementedBuildNumber + "";
            BuildnumberFile.writeLine(buildNumber, buildNumberFile);
            return buildNumber;
        }
    }

    static class BambooBuildServer
    extends AbstractBuildServer {
        BambooBuildServer() {
        }

        @Override
        public String getBranchName() {
            return System.getenv("bamboo_repository_branch_name");
        }

        @Override
        public String getJobName() {
            return System.getenv("bamboo_buildKey");
        }

        @Override
        public String getProductName() {
            return "bamboo";
        }

        @Override
        public String getBuildNumber() throws IOException {
            String bambooBuildNumber = System.getenv("bamboo_buildNumber");
            return bambooBuildNumber;
        }
    }

    static class JenkinsBuildServer
    extends AbstractBuildServer {
        JenkinsBuildServer() {
        }

        @Override
        public String getBranchName() {
            return System.getenv("GIT_BRANCH");
        }

        @Override
        public String getJobName() {
            return System.getenv("JOB_NAME");
        }

        @Override
        public String getProductName() {
            return "jenkins";
        }

        @Override
        public String getBuildNumber() throws IOException {
            String jenkinsBuildNumber = System.getenv("BUILD_NUMBER");
            return jenkinsBuildNumber;
        }
    }
}

