/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.BuildServer;
import ch.inftec.ju.versioverride.Version;
import ch.inftec.ju.versioverride.VersionFactory;
import java.io.IOException;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public class PomStrategyTest {
    @Mock
    Model model = (Model)Mockito.mock(Model.class);
    @Mock
    BuildServer buildServer = (BuildServer)Mockito.mock(BuildServer.class);

    @Before
    public void before() {
        VersionFactory.version = null;
    }

    @Test
    public void testReleaseClassifierOnMasterBranch() {
        System.setProperty("version.override", "true");
        System.setProperty("classifier.type", "RELEASE");
        try {
            Mockito.when((Object)this.buildServer.getBuildNumber()).thenReturn((Object)"55");
            Mockito.when((Object)this.buildServer.getBranchName()).thenReturn((Object)"origin/master");
            Mockito.when((Object)this.buildServer.isOnMasterBranch()).thenReturn((Object)true);
            Mockito.when((Object)this.model.getGroupId()).thenReturn((Object)"ch.inftec.ju.test");
            Mockito.when((Object)this.model.getVersion()).thenReturn((Object)"5.6.1-SNAPSHOT");
            Version version = VersionFactory.create(null, (Model)this.model, (BuildServer)this.buildServer, (Logger)new ConsoleLogger());
            Assert.assertNotNull((Object)version);
            junit.framework.Assert.assertEquals((String)"5.6.1-55", (String)version.getOverriddenVersion());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testReleaseClassifierOnNonMasterBranch() {
        System.setProperty("version.override", "true");
        System.setProperty("classifier.type", "RELEASE");
        try {
            Mockito.when((Object)this.buildServer.getBuildNumber()).thenReturn((Object)"55");
            Mockito.when((Object)this.buildServer.isOnMasterBranch()).thenReturn((Object)false);
            Mockito.when((Object)this.buildServer.getBranchName()).thenReturn((Object)"origin/rc/7.5.5");
            Mockito.when((Object)this.model.getGroupId()).thenReturn((Object)"ch.inftec.ju.test");
            Mockito.when((Object)this.model.getVersion()).thenReturn((Object)"5.6.1-SNAPSHOT");
            Version version = VersionFactory.create(null, (Model)this.model, (BuildServer)this.buildServer, (Logger)new ConsoleLogger());
            Assert.assertNotNull((Object)version);
            junit.framework.Assert.assertEquals((String)"5.6.1-rc-55", (String)version.getOverriddenVersion());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDevelopClassifierOnDevelopBranch() {
        System.setProperty("version.override", "true");
        System.setProperty("classifier.type", "DEVELOP");
        try {
            Mockito.when((Object)this.buildServer.getBuildNumber()).thenReturn((Object)"33");
            Mockito.when((Object)this.buildServer.isOnDevelopBranch()).thenReturn((Object)true);
            Mockito.when((Object)this.buildServer.getBranchName()).thenReturn((Object)"origin/develop");
            Mockito.when((Object)this.model.getGroupId()).thenReturn((Object)"ch.inftec.ju.test");
            Mockito.when((Object)this.model.getVersion()).thenReturn((Object)"6.4.1-SNAPSHOT");
            Version version = VersionFactory.create(null, (Model)this.model, (BuildServer)this.buildServer, (Logger)new ConsoleLogger());
            Assert.assertNotNull((Object)version);
            junit.framework.Assert.assertEquals((String)"6.4.1-S-33", (String)version.getOverriddenVersion());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDevelopClassifierOnNonDevelopBranch() {
        System.setProperty("version.override", "true");
        System.setProperty("classifier.type", "DEVELOP");
        try {
            Mockito.when((Object)this.buildServer.getBuildNumber()).thenReturn((Object)"33");
            Mockito.when((Object)this.buildServer.isOnDevelopBranch()).thenReturn((Object)false);
            Mockito.when((Object)this.buildServer.getBranchName()).thenReturn((Object)"origin/publish/FOOBAR-55_my_test_branch");
            Mockito.when((Object)this.model.getGroupId()).thenReturn((Object)"ch.inftec.ju.test");
            Mockito.when((Object)this.model.getVersion()).thenReturn((Object)"6.4.1-SNAPSHOT");
            Version version = VersionFactory.create(null, (Model)this.model, (BuildServer)this.buildServer, (Logger)new ConsoleLogger());
            Assert.assertNotNull((Object)version);
            junit.framework.Assert.assertEquals((String)"6.4.1-FOOBAR55-33", (String)version.getOverriddenVersion());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

