/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.AbstractVersionOverrideTest;
import ch.inftec.ju.versioverride.BuildServer;
import ch.inftec.ju.versioverride.BuildServerType;
import ch.inftec.ju.versioverride.VersionClassifier;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.junit.Assert;
import org.junit.Test;

public class VersionClassifierTest
extends AbstractVersionOverrideTest {
    BuildServer buildServer = BuildServerType.UNKNOWN.getBuildServer();

    @Test
    public void testGetDefaultProjectClassifier() throws Exception {
        System.clearProperty("classifier.type");
        String snapshotResult = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getClassifier("SNAPSHOT");
        Assert.assertEquals((Object)"S", (Object)snapshotResult);
        String nonSnapshotResult = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getClassifier("RC");
        Assert.assertEquals((Object)"RC", (Object)nonSnapshotResult);
    }

    @Test
    public void testGetPersonalClassifier() throws Exception {
        System.setProperty("classifier.type", "PERSONAL");
        System.setProperty("buildserver.type", "UNKNOWN");
        String snapshotResult = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getClassifier("SNAPSHOT");
        Assert.assertEquals((Object)"local", (Object)snapshotResult);
    }

    @Test
    public void testGetIssueIdentifier() throws Exception {
        String result = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getIssueIdentifierFromBranch("feature/TEC-7-workshop-jee-best-practices");
        Assert.assertEquals((Object)"TEC7", (Object)result);
        result = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getIssueIdentifierFromBranch("feature/PR-6598994-workshop-jee-best-practices");
        Assert.assertEquals((Object)"PR6598994", (Object)result);
        result = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getIssueIdentifierFromBranch("feature/FOOBAR-06598994-workshop-jee-best-practices");
        Assert.assertEquals((Object)"FOOBAR06598994", (Object)result);
    }

    @Test
    public void testGetNoIssueIdentifier() throws Exception {
        String result = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getIssueIdentifierFromBranch("origin/master");
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetJobIdentifier() throws Exception {
        String result = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getJobIdentifier("ajobname");
        Assert.assertEquals((Object)"ajobname", (Object)result);
    }

    @Test
    public void testGetReleaseClassifier() throws Exception {
        System.setProperty("classifier.type", "RELEASE");
        System.setProperty("buildserver.type", "UNKNOWN");
        String snapshotResult = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getClassifier("SNAPSHOT");
        Assert.assertEquals((Object)"S", (Object)snapshotResult);
    }

    @Test
    public void testGetReleaseClassifierOfNullBranch() throws Exception {
        System.setProperty("classifier.type", "RELEASE");
        System.setProperty("buildserver.type", "UNKNOWN");
        String snapshotResult = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getClassifier("foobar");
        Assert.assertEquals((Object)"foobar", (Object)snapshotResult);
    }

    @Test
    public void testGetBranchCategoryOfMaster() throws Exception {
        String result = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getReleaseIdentifierFromBranch("master/PR-55_abc");
        Assert.assertEquals((Object)"master", (Object)result);
        result = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getReleaseIdentifierFromBranch("origin/master/PR-55_abc");
        Assert.assertEquals((Object)"master", (Object)result);
    }

    @Test
    public void testGetBranchCategoryOfBetaBranch() throws Exception {
        String result = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getReleaseIdentifierFromBranch("beta/PR-88_a-branch");
        Assert.assertEquals((Object)"beta", (Object)result);
    }

    @Test
    public void testGetBranchCategoryOfBetaBranch2() throws Exception {
        String result = new VersionClassifier((Logger)new ConsoleLogger(), this.buildServer).getReleaseIdentifierFromBranch("origin/rc/PR-89_a-branch");
        Assert.assertEquals((Object)"rc", (Object)result);
    }
}

