/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.AbstractVersionOverrideTest;
import ch.inftec.ju.versioverride.VersionOverrideModelReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.junit.Assert;
import org.junit.Test;

public class GeneratedVersionModelReaderTest
extends AbstractVersionOverrideTest {
    @Test
    public void testWithNoPropertySet() {
        System.clearProperty("version.override");
        InputStream correctPomFile = GeneratedVersionModelReaderTest.class.getResourceAsStream("valid/single/pom.xml");
        VersionOverrideModelReader customVersionModelReader = new VersionOverrideModelReader();
        customVersionModelReader.setLogger((Logger)new ConsoleLogger());
        try {
            Model model = customVersionModelReader.read(correctPomFile, new HashMap());
            Assert.assertNotNull((Object)model);
            Assert.assertEquals((Object)"0.0.1-SNAPSHOT", (Object)model.getVersion());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWithEmptyPropertySet() {
        System.setProperty("version.override", "");
        System.clearProperty("BUILD_NUMBER");
        InputStream correctPomFile = GeneratedVersionModelReaderTest.class.getResourceAsStream("valid/single/pom.xml");
        VersionOverrideModelReader customVersionModelReader = new VersionOverrideModelReader();
        customVersionModelReader.setLogger((Logger)new ConsoleLogger());
        try {
            Model model = customVersionModelReader.read(correctPomFile, new HashMap());
            Assert.assertNotNull((Object)model);
            Assert.assertEquals((Object)"0.0.1-S-1", (Object)model.getVersion());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWithPropertySet() {
        System.setProperty("version.override", "1.2.3");
        InputStream correctPomFile = GeneratedVersionModelReaderTest.class.getResourceAsStream("valid/single/pom.xml");
        VersionOverrideModelReader customVersionModelReader = new VersionOverrideModelReader();
        customVersionModelReader.setLogger((Logger)new ConsoleLogger());
        try {
            Model model = customVersionModelReader.read(correctPomFile, new HashMap());
            Assert.assertNotNull((Object)model);
            Assert.assertEquals((Object)"1.2.3", (Object)model.getVersion());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

