package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.AbstractVersionOverrideTest;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

/**
 * Created by rotscher on 1/15/15.
 */

@RunWith(MockitoJUnitRunner.class)
public class GeneratedVersionTest extends AbstractVersionOverrideTest {

    @Mock
    Model model = mock(Model.class);

    @Test
    public void testGetOverriddenVersionWithBuildNumberFromFile() throws Exception {

        VersionOverrideModelReader customVersionModelReader = new VersionOverrideModelReader();
        customVersionModelReader.setLogger(new ConsoleLogger());
        try {
            when(model.getVersion()).thenReturn("5.8.1.4-RC");
            when(model.getGroupId()).thenReturn("ch.inftec.ju.ch.inftec.ju.versioverride.1");
            GeneratedVersion versionOverride = new GeneratedVersion(model, new ConsoleLogger());
            assertNotNull(model);
            assertEquals("5.8.1.4-RC-1", versionOverride.getOverriddenVersion());
        } catch (IOException e) {
            fail(e.getMessage());
        }
    }
}
