package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.AbstractVersionOverrideTest;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.mockito.Mockito.mock;

/**
 * Created by rotscher on 1/23/15.
 */

public class VersionClassifierTest extends AbstractVersionOverrideTest {

    BuildServer buildServer = BuildServerType.UNKNOWN.getBuildServer();

    @Test
    public void testGetDefaultProjectClassifier() throws Exception {
        System.clearProperty("classifier.type");
        String snapshotResult = new VersionClassifier(new ConsoleLogger(), buildServer).getClassifier("SNAPSHOT");
        assertEquals("S", snapshotResult);

        String nonSnapshotResult = new VersionClassifier(new ConsoleLogger(), buildServer).getClassifier("RC");
        assertEquals("RC", nonSnapshotResult);
    }

    @Test
    public void testGetPersonalClassifier() throws Exception {
        System.setProperty("classifier.type", "PERSONAL");
        System.setProperty("buildserver.type", "UNKNOWN");
        String snapshotResult = new VersionClassifier(new ConsoleLogger(), buildServer).getClassifier("SNAPSHOT");
        assertEquals("local", snapshotResult);
    }

    @Test
    public void testGetIssueIdentifier() throws Exception {
        String result = new VersionClassifier(new ConsoleLogger(), buildServer).getIssueIdentifierFromBranch("feature/TEC-7-workshop-jee-best-practices");
        assertEquals("TEC7", result);

        result = new VersionClassifier(new ConsoleLogger(), buildServer).getIssueIdentifierFromBranch("feature/PR-6598994-workshop-jee-best-practices");
        assertEquals("PR6598994", result);

        result = new VersionClassifier(new ConsoleLogger(), buildServer).getIssueIdentifierFromBranch("feature/FOOBAR-06598994-workshop-jee-best-practices");
        assertEquals("FOOBAR06598994", result);
    }

    @Test
    public void testGetNoIssueIdentifier() throws Exception {
        String result = new VersionClassifier(new ConsoleLogger(), buildServer).getIssueIdentifierFromBranch("origin/master");
        assertNull(result);
    }

    @Test
    public void testGetJobIdentifier() throws Exception {
        String result = new VersionClassifier(new ConsoleLogger(), buildServer).getJobIdentifier("ajobname");
        assertEquals("ajobname", result);
    }

    @Test
    public void testGetReleaseClassifier() throws Exception {
        System.setProperty("classifier.type", "RELEASE");
        System.setProperty("buildserver.type", "UNKNOWN");
        String snapshotResult = new VersionClassifier(new ConsoleLogger(), buildServer).getClassifier("SNAPSHOT");
        assertEquals("S", snapshotResult);
    }

    @Test
    public void testGetReleaseClassifierOfNullBranch() throws Exception {
        System.setProperty("classifier.type", "RELEASE");
        System.setProperty("buildserver.type", "UNKNOWN");
        String snapshotResult = new VersionClassifier(new ConsoleLogger(), buildServer).getClassifier("foobar");
        assertEquals("foobar", snapshotResult);
    }

    @Test
    public void testGetBranchCategoryOfMaster() throws Exception {
        String result = new VersionClassifier(new ConsoleLogger(), buildServer).getReleaseIdentifierFromBranch("master/PR-55_abc");
        assertEquals("master", result);

        result = new VersionClassifier(new ConsoleLogger(), buildServer).getReleaseIdentifierFromBranch("origin/master/PR-55_abc");
        assertEquals("master", result);
    }

    @Test
    public void testGetBranchCategoryOfBetaBranch() throws Exception {
        String result = new VersionClassifier(new ConsoleLogger(), buildServer).getReleaseIdentifierFromBranch("beta/PR-88_a-branch");
        assertEquals("beta", result);
    }

    @Test
    public void testGetBranchCategoryOfBetaBranch2() throws Exception {
        String result = new VersionClassifier(new ConsoleLogger(), buildServer).getReleaseIdentifierFromBranch("origin/rc/PR-89_a-branch");
        assertEquals("rc", result);
    }
}
