package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.AbstractVersionOverrideTest;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import java.io.IOException;

import static org.junit.Assert.*;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

/**
 * Created by rotscher on 1/15/15.
 */

@RunWith(MockitoJUnitRunner.class)
public class GeneratedVersionJenkinsTest extends AbstractVersionOverrideTest {

    @Mock
    Model model = mock(Model.class);

    @Test
    public void testGetOverridenWithinJenkins() throws Exception {
        System.setProperty("BUILD_NUMBER", "858");

        VersionOverrideModelReader customVersionModelReader = new VersionOverrideModelReader();
        customVersionModelReader.setLogger(new ConsoleLogger());
        try {
            when(model.getVersion()).thenReturn("6.1.1.4-SNAPSHOT");
            when(model.getGroupId()).thenReturn("ch.inftec.ju.ch.inftec.ju.versioverride.3");
            GeneratedVersion versionOverride = new GeneratedVersion(model, new ConsoleLogger());
            assertNotNull(model);
            assertEquals("6.1.1.4-S-858", versionOverride.getOverriddenVersion());
        } catch (IOException e) {
            fail(e.getMessage());
        }
    }

}
