package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.AbstractVersionOverrideTest;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;

/**
 * Created by rotscher on 1/23/15.
 */
public class BambooClassifierTest extends AbstractVersionOverrideTest {

    BuildServer buildServer = BuildServerType.BAMBOO.getBuildServer();

    @Test
    public void testGetPersonalClassifier() throws Exception {
        System.setProperty("classifier.type", "PERSONAL");
        String snapshotResult = new VersionClassifier(new ConsoleLogger(), buildServer).getClassifier("SNAPSHOT");
        assertEquals("bamboo-build_TEC888", snapshotResult);
    }

    @Test
    public void testGetReleaseClassifier() throws Exception {
        System.setProperty("classifier.type", "RELEASE");
        System.setProperty("buildserver.type", "BAMBOO");
        String snapshotResult = new VersionClassifier(new ConsoleLogger(), buildServer).getClassifier("SNAPSHOT");
        assertEquals("bamboo", snapshotResult);
    }
}
