package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.GeneratedVersion;
import ch.inftec.ju.versioverride.Version;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.Logger;

import java.io.IOException;


/**
 * factory for creating and caching the version strategy for a build
 */
public class VersionFactory {

    /* package private for unit test cleanup */
    static Version version;

    /**
     * create and return the version strategy, which is either a static value in case the version is given as
     * system property (-Dversion.override=1.0)  or it's a generated version in case the version override feature is
     * enabled (-Dversion.override) but no static value is given.
     *
     * @param versionOverride a static version or an empty string
     * @param model the maven model
     * @param logger a maven logger
     * @return a version instance for handling overridden version
     * @throws IOException
     */
    public static Version create(String versionOverride, Model model, Logger logger) throws IOException {
        if (version == null) {
            if (versionOverride.trim().length() < 1 || Boolean.valueOf(versionOverride)) {
                version = new GeneratedVersion(model, logger);
            } else {
                version = new StaticVersion(model, versionOverride, logger);
            }

            logger.info(String.format("version for version.override is %s", version.getOverriddenVersion()));

        }

        return version;
    }
}
