package ch.inftec.ju.versioverride;

import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.Logger;

import java.io.IOException;

/**
 * Created by rotscher on 1/15/15.
 */
public class StaticVersion implements Version {


    private final String groupId;
    private final String originalVersion;
    private final String version;

    public StaticVersion(Model model, String overriddenVersion, Logger logger) throws IOException {
        this.groupId = VersionOverrideModelReader.getGroupId(model);
        this.originalVersion = model.getVersion();
        this.version = overriddenVersion;
        //System.setProperty(MAVENEXT_RELEASE_VERSION, this.version);

        logger.info(String
                .format("initialize groupId to '%s', the version of all modules and dependencies starting with this groupdId will be changed!",
                        groupId));
    }

    @Override
    public String getOriginalVersion() {
        return originalVersion;
    }

    @Override
    public String getGroupId() {
        return groupId;
    }

    @Override
    public String getOverriddenVersion() {
        return version;
    }
}
