package ch.inftec.ju.versioverride;

import ch.inftec.ju.versioverride.BuildServer;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.Logger;

import java.io.*;

/**
 * Created by rotscher on 1/15/15.
 */
public class GeneratedVersion implements Version {
    private final String groupId;
    private final String originalVersion;
    private final String version;
    private final Logger logger;

    public GeneratedVersion(Model model, Logger logger) throws IOException {
        this.logger = logger;
        this.groupId = VersionOverrideModelReader.getGroupId(model);
        this.originalVersion = model.getVersion();
        this.version = generateVersion(model);
        //System.setProperty(MAVENEXT_RELEASE_VERSION, this.version);

        logger.info(String
                .format("initialize groupId to '%s', the version of all modules and dependencies starting with this groupdId will be changed!",
                        groupId));
    }

    private String generateVersion(Model model) throws IOException {

        //generate a version based on the {project.version}
        String[] pomVersionTokens = model.getVersion().split("-");
        if (pomVersionTokens.length == 1) {
            return model.getVersion();
        }

        BuildServer buildServer = detectBuildServer().getBuildServer();

        if (buildServer.isOnMasterBranch()) {
            return model.getVersion();
        }

        String versionNumber = pomVersionTokens[0];
        String classifier = new VersionClassifier(logger, buildServer).getClassifier(pomVersionTokens[1]);
        String buildNumber = buildServer.getBuildNumber();

        return String.format("%s-%s-%s", versionNumber, classifier, buildNumber);
    }

    BuildServerType detectBuildServer() {

        String buildServerProperty = System.getProperty("buildserver.type");
        if (buildServerProperty != null && buildServerProperty.trim().length() > 0) {
            BuildServerType type = BuildServerType.valueOf(buildServerProperty);
            if (type != null) {
                logger.info(String
                        .format("using buildserver '%s', which was set with -Dbuildserver.type=%s",
                                type.getBuildServer().getProductName(), buildServerProperty));
                return type;
            }
        }

        BuildServerType type = BuildServerType.UNKNOWN;
        /* used to print build server information */
        String buildServerEnvironment = "";

        if (System.getenv("JOB_NAME") != null && !System.getenv("JOB_NAME").equals("null")) {
            type = BuildServerType.JENKINS;
            buildServerEnvironment = String.format(" (based on environment 'JOB_NAME' which was set to '%s)'", System.getenv("JOB_NAME"));
        } else if (System.getenv("bamboo_buildKey") != null && !System.getenv("bamboo_buildKey").equals("null")) {
            type = BuildServerType.BAMBOO;
            buildServerEnvironment = String.format(" (based on environment 'bamboo_buildKey' which was set to '%s)'", System.getenv("bamboo_buildKey"));
        }
        logger.info(String
                .format("detected buildserver '%s'%s, " +
                        "override this with setting -Dbuildserver.type=JENKINS|BAMBOO|UNKNOWN",
                        type.getBuildServer().getProductName(), buildServerEnvironment));
        return type;

    }

    @Override
    public String getOriginalVersion() {
        return originalVersion;
    }

    @Override
    public String getGroupId() {
        return groupId;
    }

    @Override
    public String getOverriddenVersion() {
        return version;
    }
}
