/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.xml;

import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuException;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.collection.Cache;
import ch.inftec.ju.util.collection.Caches;
import ch.inftec.ju.util.function.Function;
import ch.inftec.ju.util.xml.JuNamespacePrefixMapper;
import ch.inftec.ju.util.xml.XPathGetter;
import ch.inftec.ju.util.xml.XmlBuilder;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XmlUtils {
    private static DatatypeFactory df = null;
    private static final String ATTR_INDENT_NUMBER = "indent-number";
    private static final int INDENT_NUMBER = 2;

    private static synchronized DatatypeFactory getDatetypeFactory() {
        if (df == null) {
            try {
                df = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException dce) {
                throw new IllegalStateException("Exception while obtaining DatatypeFactory instance", dce);
            }
        }
        return df;
    }

    private XmlUtils() {
        throw new AssertionError((Object)"use only statically");
    }

    public static Document loadXml(URL xmlUrl) throws JuException {
        return XmlUtils.loadXml(xmlUrl, null);
    }

    public static XPathGetter loadXmlAsXPathGetter(URL xmlUrl) throws JuException {
        return new XPathGetter(XmlUtils.loadXml(xmlUrl));
    }

    public static Document loadXml(URL xmlUrl, URL schemaUrl) throws JuException {
        Document document;
        if (xmlUrl == null) {
            throw new NullPointerException("xmlUrl must not be null");
        }
        BufferedInputStream xmlStream = null;
        try {
            xmlStream = new BufferedInputStream(xmlUrl.openStream());
            document = XmlUtils.loadXml(new InputSource(xmlStream), XmlUtils.loadSchema(schemaUrl), false);
        }
        catch (Exception ex) {
            try {
                throw new JuException(String.format("Couldn't load XML from URL: %s (Schema URL: %s)", xmlUrl, schemaUrl), ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(xmlStream);
                throw throwable;
            }
        }
        IOUtil.close(xmlStream);
        return document;
    }

    public static Document loadXml(InputStream inputStream, Schema schema) throws JuException {
        Document document;
        BufferedInputStream xmlStream = null;
        try {
            xmlStream = new BufferedInputStream(inputStream);
            document = XmlUtils.loadXml(new InputSource(xmlStream), schema, false);
        }
        catch (Exception ex) {
            try {
                throw new JuException("Couldn't load XML from InputStream", ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(xmlStream);
                throw throwable;
            }
        }
        IOUtil.close(xmlStream);
        return document;
    }

    public static Document loadXml(InputSource xmlSource, Schema schema, boolean nameSpaceAware) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(nameSpaceAware);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(xmlSource);
            XmlUtils.removeWhitespaceNodes(doc.getDocumentElement());
            if (schema != null) {
                schema.newValidator().validate(new DOMSource(doc));
            }
            return doc;
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't load XML", ex);
        }
    }

    private static void removeWhitespaceNodes(Element e) {
        NodeList children = e.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node child = children.item(i);
            if (child instanceof Text && ((Text)child).getData().trim().length() == 0) {
                e.removeChild(child);
                continue;
            }
            if (!(child instanceof Element)) continue;
            XmlUtils.removeWhitespaceNodes((Element)child);
        }
    }

    public static Document loadXml(String xmlString, Schema schema) {
        return XmlUtils.loadXml(new InputSource(new StringReader(xmlString)), schema, false);
    }

    public static Document loadXml(String xmlString, Schema schema, boolean nameSpaceAware) throws JuException {
        return XmlUtils.loadXml(new InputSource(new StringReader(xmlString)), schema, nameSpaceAware);
    }

    public static Schema loadSchema(URL url) {
        if (url == null) {
            return null;
        }
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            return schemaFactory.newSchema(url);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't load XML schema: " + url, ex);
        }
    }

    public static String indentXml(String xmlString, boolean includeXmlDeclaration) {
        Document doc = XmlUtils.loadXml(xmlString, null);
        return XmlUtils.toString(doc, includeXmlDeclaration, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toString(Document document, boolean includeXmlDeclaration, boolean indent) throws JuRuntimeException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                tf.setAttribute(ATTR_INDENT_NUMBER, 2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", includeXmlDeclaration ? "no" : "yes");
            if (indent) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
            }
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                transformer.transform(new DOMSource(document), new StreamResult(os));
                String string = new String(os.toByteArray(), "UTF-8");
                return string;
            }
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't convert XML to String", ex);
        }
    }

    public static XmlBuilder buildXml(String rootElementName) {
        return XmlBuilder.createRootBuilder(rootElementName, null, null);
    }

    public static XmlBuilder buildXml(String rootElementName, String namespacePrefix, String namespaceUri) {
        return XmlBuilder.createRootBuilder(rootElementName, namespacePrefix, namespaceUri);
    }

    public static MarshallerBuilder marshaller() {
        return new MarshallerBuilder();
    }

    public static void validate(String xml, Schema schema) throws JuException {
        try {
            schema.newValidator().validate(new DOMSource(XmlUtils.loadXml(xml, null)));
        }
        catch (SAXParseException ex) {
            throw new JuException("Parse exception: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new JuException("Validation failed", ex);
        }
    }

    public static void validate(String xml, Schema schema, boolean nameSpaceAware) throws JuException {
        try {
            schema.newValidator().validate(new DOMSource(XmlUtils.loadXml(xml, null, nameSpaceAware)));
        }
        catch (SAXParseException ex) {
            throw new JuException("Parse exception: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new JuException("Validation failed", ex);
        }
    }

    public static XMLGregorianCalendar asXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.setTimeZone(TimeZone.getTimeZone("GMT"));
        return XmlUtils.getDatetypeFactory().newXMLGregorianCalendar(gc);
    }

    public static Date asDate(XMLGregorianCalendar xgc) {
        if (xgc == null) {
            return null;
        }
        return xgc.toGregorianCalendar().getTime();
    }

    public static class MarshallerBuilder {
        private final Logger logger = LoggerFactory.getLogger(MarshallerBuilder.class);
        private boolean cacheJaxbContext = true;
        private static Cache<String, JAXBContext> cache;
        private static int MAX_CACHE_SIZE;
        private boolean formattedOutput = false;
        private Schema schema;
        private JuNamespacePrefixMapper prefixMapper;
        private NamespacePrefixMapperAdapter prefixMapperAdapter;

        public MarshallerBuilder formattedOutput(boolean formattedOutput) {
            this.formattedOutput = formattedOutput;
            return this;
        }

        public MarshallerBuilder schema(URL schemaUrl) {
            this.schema = XmlUtils.loadSchema(schemaUrl);
            return this;
        }

        public MarshallerBuilder setNamespacePrefix(String prefix, String namespaceUri) {
            if (this.prefixMapper == null) {
                this.prefixMapper = new JuNamespacePrefixMapper();
            }
            this.prefixMapper.setPrefix(prefix, namespaceUri);
            return this;
        }

        public MarshallerBuilder setNamespacePrefixMapper(NamespacePrefixMapperAdapter prefixMapperAdapter) {
            this.prefixMapperAdapter = prefixMapperAdapter;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String marshalToString(Object o) {
            try (StringWriter writer = new StringWriter();){
                Object obj = o;
                if (o instanceof JAXBElement) {
                    JAXBElement e = (JAXBElement)o;
                    obj = e.getValue();
                }
                this.logger.debug("Marshalling " + obj.getClass());
                JAXBContext context = this.loadContext(obj.getClass().getPackage().getName());
                Marshaller marshaller = context.createMarshaller();
                marshaller.setSchema(this.schema);
                if (this.formattedOutput) {
                    marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                }
                if (this.prefixMapper != null) {
                    AssertUtil.assertNotNull("Prefix Mapper must be specified when using prefix mapping", this.prefixMapperAdapter);
                    marshaller.setProperty(this.prefixMapperAdapter.getPropertyName(), this.prefixMapperAdapter.getNamespacePrefixMapperImplementation(this.prefixMapper));
                }
                marshaller.marshal(o, (Writer)writer);
                String xmlString = writer.toString();
                this.logger.debug("Marshalling done");
                String string = xmlString;
                return string;
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't marshal object %s (using Schema: %s)", (Throwable)ex, o, null);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object unmarshalRaw(String xmlString, Class<?> objClass) {
            try (StringReader reader = new StringReader(xmlString);){
                JAXBContext context = this.loadContext(objClass.getPackage().getName());
                Unmarshaller unmarshaller = context.createUnmarshaller();
                unmarshaller.setSchema(this.schema);
                Object obj = unmarshaller.unmarshal((Reader)reader);
                if (obj instanceof JAXBElement) {
                    obj = ((JAXBElement)obj).getValue();
                }
                Object object = obj;
                return object;
            }
            catch (Exception ex) {
                this.logger.debug("Marshalling of String failed: " + xmlString);
                throw new JuRuntimeException("Couldn't unmarshal XML String (XML is dumped as debug log)", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JAXBContext loadContext(String contextPath) throws JAXBException {
            if (this.cacheJaxbContext) {
                MarshallerBuilder marshallerBuilder = this;
                synchronized (marshallerBuilder) {
                    if (cache == null) {
                        cache = Caches.simpleBoundedCache(MAX_CACHE_SIZE, new Function<String, JAXBContext>(){

                            @Override
                            public JAXBContext apply(String key) {
                                return MarshallerBuilder.this.createContext(key);
                            }
                        });
                    }
                }
                return cache.get(contextPath);
            }
            return this.createContext(contextPath);
        }

        private JAXBContext createContext(String contextPath) {
            this.logger.debug("Creating JAXBContext for path {}", (Object)contextPath);
            try {
                return JAXBContext.newInstance((String)contextPath);
            }
            catch (JAXBException ex) {
                throw new JuRuntimeException("Couldn't create JAXB context", ex);
            }
        }

        public <T> T unmarshal(String xmlString, Class<T> objClass) {
            Object object = this.unmarshalRaw(xmlString, objClass);
            return (T)object;
        }

        public <T> T unmarshal(URL xmlUrl, Class<T> objClass) {
            String xmlString = new IOUtil().loadTextFromUrl(xmlUrl, new String[0]);
            Object object = this.unmarshalRaw(xmlString, objClass);
            return (T)object;
        }

        static {
            MAX_CACHE_SIZE = 100;
        }

        public static interface NamespacePrefixMapperAdapter {
            public String getPropertyName();

            public Object getNamespacePrefixMapperImplementation(PrefixMapper var1);

            public static interface PrefixMapper {
                public String getPreferredPrefix(String var1, String var2, boolean var3);
            }
        }
    }
}

