/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.xml;

import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.xml.XmlUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XmlOutputConverter {
    private final Logger logger = LoggerFactory.getLogger(XmlOutputConverter.class);
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public Document getDocument() throws JuRuntimeException {
        try {
            IOUtil.close(this.outputStream);
            byte[] bytes = this.outputStream.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            return XmlUtils.loadXml(inputStream, null);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't convert byte stream to XML document", ex);
        }
    }

    public String getXmlString() {
        try {
            return this.outputStream.toString("utf-8");
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't convert byte stream to String", ex);
        }
    }

    public void writeToXmlFile(Path file) {
        this.logger.debug("Writing dataset to XML file: " + file);
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file.toFile()));){
            ((OutputStream)stream).write(this.outputStream.toByteArray());
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't write DB data to file " + file, ex);
        }
    }
}

