/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.jmx;

import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.helper.ValueConverter;
import ch.inftec.ju.util.helper.ValueConverterFactory;
import ch.inftec.ju.util.jmx.MBeanUtil;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MBeanUtils {
    public static MBeanUtil queryPlatformMBeanServer(String objectName) {
        return new MBeanUtilImpl(ManagementFactory.getPlatformMBeanServer(), objectName);
    }

    private static final class MBeanUtilImpl
    implements MBeanUtil {
        private final MBeanServer server;
        private final ObjectName objectName;

        private MBeanUtilImpl(MBeanServer server, String objectName) {
            this.server = server;
            try {
                this.objectName = new ObjectName(objectName);
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't create ObjectName for %s", (Throwable)ex, objectName);
            }
        }

        @Override
        public ValueConverter getAttribute(String attributeName) {
            try {
                return ValueConverterFactory.createNewValueConverter(this.server.getAttribute(this.objectName, attributeName));
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't get attribute %s from MBean object %s", (Throwable)ex, attributeName, this.objectName);
            }
        }
    }
}

