/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.helper;

import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.function.Function;
import ch.inftec.ju.util.helper.FindHelper;
import ch.inftec.ju.util.helper.FindNoneHelper;
import java.util.Collection;

public class FindHelperBuilder<T> {
    private Iterable<? extends T> items;
    private T noneObject;

    public FindHelperBuilder<T> iterable(Iterable<? extends T> iterable) {
        this.items = iterable;
        return this;
    }

    public <S> FindHelperBuilder<T> iterableTransformed(Iterable<S> srcIterable, Function<S, ? extends T> transformer) {
        Iterable<? extends T> iterableTransformed = JuCollectionUtils.iterableTransformed(srcIterable, transformer);
        return this.iterable(iterableTransformed);
    }

    @Deprecated
    public FindHelperBuilder<T> collection(Collection<? extends T> coll) {
        return this.iterable(coll);
    }

    @Deprecated
    public <S> FindHelperBuilder<T> collectionTransformed(Collection<S> srcColl, Function<S, ? extends T> transformer) {
        return this.iterableTransformed(srcColl, transformer);
    }

    public FindHelperBuilder<T> noneObject(T noneObject) {
        this.noneObject = noneObject;
        return this;
    }

    public FindHelper<T> createFindHelper() {
        AssertUtil.assertNotNull("Iterable must be specified", this.items);
        return new FindHelper<T>(this.items);
    }

    public FindNoneHelper<T> createFindNoneHelper() {
        AssertUtil.assertNotNull("Iterable must be specified", this.items);
        AssertUtil.assertNotNull("None Object must be specified", this.noneObject);
        return new FindNoneHelper<T>(this.items, this.noneObject);
    }
}

