/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.RegexUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jasypt.util.digest.Digester;

public final class JuStringUtils {
    public static final String NEW_LINE = "\n";
    public static final String LF = "\n";
    public static final String CRLF = "\r\n";
    public static final SimpleDateFormat DATE_FORMAT_DAYS = new SimpleDateFormat("dd.MM.yyyy");
    public static final SimpleDateFormat DATE_FORMAT_HOURS = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    public static final SimpleDateFormat DATE_FORMAT_SECONDS = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    public static final SimpleDateFormat TIMESTAMP_FORMAT_SECONDS = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private static final SimpleDateFormat DATE_FORMAT_ZULU = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    private JuStringUtils() {
        throw new AssertionError((Object)"use only statically");
    }

    public static Date toDate(String s, SimpleDateFormat dateFormat) throws ParseException {
        return dateFormat.parse(s);
    }

    public static String toZuluDateString(Date date) {
        int offset = TimeZone.getDefault().getOffset(date.getTime());
        Date zuluDate = new Date(date.getTime() - (long)offset);
        return DATE_FORMAT_ZULU.format(zuluDate);
    }

    public static Date parseIso8601Date(String iso8601Date) {
        try {
            return DatatypeConverter.parseDateTime((String)iso8601Date).getTime();
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Not a ISO 8601 compliant date string: " + iso8601Date);
        }
    }

    public static String crop(String s, int maxLength) {
        if (s == null || s.length() <= maxLength) {
            return s;
        }
        return s.substring(0, Math.max(0, maxLength));
    }

    public static String removeNonAlphabeticalLeadingCharacters(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        int i = new RegexUtil("[a-zA-Z]").getFirstMatchIndex(s);
        if (i < 0) {
            return "";
        }
        return s.substring(i);
    }

    public static String times(String s, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String replaceAll(String s, String ... replacements) {
        if (replacements.length % 2 != 0) {
            throw new IllegalArgumentException("replacements parameter must consist of 0-n key-value pairs");
        }
        if (replacements.length == 0 || s == null) {
            return s;
        }
        for (int i = 0; i < replacements.length; i += 2) {
            String key = replacements[i];
            String value = replacements[i + 1];
            s = s.replaceAll("%" + key + "%", Matcher.quoteReplacement(value));
        }
        return s;
    }

    public static int occurrancies(String s, String substring) {
        if (s == null || substring == null) {
            return 0;
        }
        int cnt = 0;
        int index = -1;
        while ((index = s.indexOf(substring, index + 1)) >= 0) {
            ++cnt;
        }
        return cnt;
    }

    public static boolean containsWhitespace(String s) {
        return s != null && s.length() > 0 && new RegexUtil("\\s").containsMatch(s);
    }

    public static String toString(Object obj, Object ... keyValuePairs) {
        ToStringBuilder b = new ToStringBuilder(obj, ToStringStyle.SHORT_PREFIX_STYLE);
        for (int i = 1; i < keyValuePairs.length; i += 2) {
            b.append(ObjectUtils.toString((Object)keyValuePairs[i - 1]), keyValuePairs[i]);
        }
        return b.toString();
    }

    public static String[] split(String s, String dividingString, boolean trim) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return new String[0];
        }
        String whitespaceRegex = trim ? String.format("[%s]*", "\\s") : "";
        String regex = whitespaceRegex + Pattern.quote(dividingString) + whitespaceRegex;
        String[] res = s.split(regex);
        if (trim) {
            if (res.length > 0) {
                res[0] = res[0].trim();
            }
            if (res.length > 1) {
                res[res.length - 1] = res[res.length - 1].trim();
            }
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStackTrace(Throwable t) {
        try (StringWriter w = new StringWriter();){
            PrintWriter pw = new PrintWriter(w);
            t.printStackTrace(pw);
            String string = w.toString();
            return string;
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't get stacktrace", ex);
        }
    }

    public static String getMd5Checksum(String s) {
        Digester digester = new Digester();
        return JuStringUtils.toHexString(digester.digest(s.getBytes()));
    }

    public static String toHexString(byte[] b) {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < b.length; ++j) {
            sb.append(Integer.toHexString(b[j] & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public static LoremIpsumCreator createLoremIpsum() {
        return new LoremIpsumCreator();
    }

    public static class LoremIpsumCreator {
        public static final String LOREM_IPSUM = "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.";
        private String[] loremIpsumWords = "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.".split("\\s");

        public String getWords() {
            return this.getWords(50);
        }

        public String getWords(int amount) {
            return this.getWords(amount, 0);
        }

        public String getWords(int amount, int startIndex) {
            if (startIndex < 0 || startIndex > 49) {
                throw new IndexOutOfBoundsException("startIndex must be >= 0 and < 50");
            }
            int word = startIndex;
            StringBuilder lorem = new StringBuilder();
            for (int i = 0; i < amount; ++i) {
                if (word == 50) {
                    word = 0;
                }
                lorem.append(this.loremIpsumWords[word]);
                if (i < amount - 1) {
                    lorem.append(' ');
                }
                ++word;
            }
            return lorem.toString();
        }

        public String getParagraphs() {
            return this.getParagraphs(2);
        }

        public String getParagraphs(int amount) {
            StringBuilder lorem = new StringBuilder();
            for (int i = 0; i < amount; ++i) {
                lorem.append(LOREM_IPSUM);
                if (i >= amount - 1) continue;
                lorem.append("\n\n");
            }
            return lorem.toString();
        }
    }
}

