/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.TestUtils;
import ch.inftec.ju.util.function.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class JuCollectionUtilsTest {
    private List<Integer> list12 = Arrays.asList(1, 2);
    private List<Integer> list12_copy = Arrays.asList(1, 2);
    private List<Integer> list23 = Arrays.asList(2, 3);
    private List<Integer> list123 = Arrays.asList(1, 2, 3);
    private List<Integer> list21 = Arrays.asList(2, 1);
    private List<Integer> list34 = Arrays.asList(3, 4);

    @Test
    public void iterator_asList() {
        final ArrayList<String> l = JuCollectionUtils.arrayList("A", "B");
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return l.iterator();
            }
        };
        List<String> lRes = JuCollectionUtils.asList(iterable);
        TestUtils.assertCollectionEquals(lRes, "A", "B");
    }

    @Test
    public void nullAndCollection_collectionEquals_returnsFalse() {
        Assert.assertFalse((boolean)JuCollectionUtils.collectionEquals(this.list12, null));
    }

    @Test
    public void nullAndNull_collectionEquals_returnsTrue() {
        Assert.assertTrue((boolean)JuCollectionUtils.collectionEquals(null, null));
    }

    @Test
    public void nullAndEmpty_collectionEquals_returnsFalse() {
        Assert.assertFalse((boolean)JuCollectionUtils.collectionEquals(null, Collections.emptyList()));
    }

    @Test
    public void sameCollection_collectionEquals_returnsTrue() {
        Assert.assertTrue((boolean)JuCollectionUtils.collectionEquals(this.list12, this.list12));
    }

    @Test
    public void equalCollection_collectionEquals_returnsTrue() {
        Assert.assertNotSame(this.list12, this.list12_copy);
        Assert.assertTrue((boolean)JuCollectionUtils.collectionEquals(this.list12, this.list12_copy));
    }

    @Test
    public void nonEqualCollectionDifferentLength_collectionEquals_returnsFalse() {
        Assert.assertFalse((boolean)JuCollectionUtils.collectionEquals(this.list12, this.list123));
    }

    @Test
    public void nonEqualCollectionSameLength_collectionEquals_returnsFalse() {
        Assert.assertFalse((boolean)JuCollectionUtils.collectionEquals(this.list12, this.list23));
    }

    @Test
    public void collectionWithSameItemsDifferentOrder_collectionEquals_returnsFalse() {
        Assert.assertFalse((boolean)JuCollectionUtils.collectionEquals(this.list12, this.list21));
    }

    @Test
    public void collectionWithSameItemsDifferentOrder_collectionEqualsIgnoreOrder_returnsTrue() {
        Assert.assertTrue((boolean)JuCollectionUtils.collectionEqualsIgnoreOrder(this.list12, this.list21));
    }

    @Test
    public void nullParameter_intersection_returnsEmptyList() {
        Assert.assertTrue((boolean)JuCollectionUtils.intersection(null, this.list12).isEmpty());
    }

    @Test
    public void sameCollection_intersection_returnsNewList() {
        List<Integer> intersection = JuCollectionUtils.intersection(this.list12, this.list12);
        Assert.assertNotSame(this.list12, intersection);
        Assert.assertTrue((boolean)JuCollectionUtils.collectionEquals(this.list12, intersection));
    }

    @Test
    public void nonOverlappingCollections_intersection_returnsEmptyList() {
        Assert.assertTrue((boolean)JuCollectionUtils.intersection(this.list12, this.list34).isEmpty());
    }

    @Test
    public void overlappingCollections_intersection_returnsOverlappingItems() {
        List<Integer> intersection = JuCollectionUtils.intersection(this.list12, this.list123);
        Assert.assertNotSame(this.list12, intersection);
        Assert.assertTrue((boolean)JuCollectionUtils.collectionEquals(this.list12, intersection));
    }

    @Test
    public void iteratorTransformed_transformsElements() {
        ArrayList<Integer> list = JuCollectionUtils.asArrayList(1, 2);
        Iterator<Integer> transformedIterator = JuCollectionUtils.iteratorTransformed(list.iterator(), this.getMultiplyByTwoFunction());
        Assert.assertEquals((Object)2, (Object)transformedIterator.next());
        Assert.assertEquals((Object)4, (Object)transformedIterator.next());
        Assert.assertFalse((boolean)transformedIterator.hasNext());
    }

    private Function<Integer, Integer> getMultiplyByTwoFunction() {
        return new Function<Integer, Integer>(){

            @Override
            public Integer apply(Integer integer) {
                return integer * 2;
            }
        };
    }

    @Test
    public void iterableTransformed_transformsElements() {
        ArrayList<Integer> list = JuCollectionUtils.asArrayList(1);
        Iterable<Integer> transformedIterable = JuCollectionUtils.iterableTransformed(list, this.getMultiplyByTwoFunction());
        Iterator<Integer> transformedIterator = transformedIterable.iterator();
        Assert.assertEquals((Object)2, (Object)transformedIterator.next());
        Assert.assertFalse((boolean)transformedIterator.hasNext());
    }
}

