/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.RegexUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class ConversionUtils {
    private static RegexUtil LONG_REGEX = new RegexUtil("[+-]?\\d+");

    private ConversionUtils() {
        throw new AssertionError((Object)"use only statically");
    }

    public static BigDecimal toBigDecimal(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return new BigDecimal((Integer)o);
        }
        if (o instanceof Long) {
            return new BigDecimal((Long)o);
        }
        if (o instanceof Float) {
            return new BigDecimal(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return new BigDecimal((Double)o);
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        return null;
    }

    public static Long toLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof BigInteger) {
            return ((BigInteger)o).longValue();
        }
        if (o instanceof String) {
            String s = (String)o;
            if (!LONG_REGEX.matches(s)) {
                return null;
            }
            return Long.parseLong((String)o);
        }
        BigDecimal bd = ConversionUtils.toBigDecimal(o);
        return bd == null ? null : Long.valueOf(bd.longValue());
    }

    public static Date newDate(int year, int month, int day) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.set(year, month, day);
        return cal.getTime();
    }
}

