/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.security;

import au.com.bytecode.opencsv.CSVReader;
import ch.inftec.ju.security.JuTextEncryptor;
import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuException;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.RegexUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jasypt.util.text.BasicTextEncryptor;
import org.jasypt.util.text.StrongTextEncryptor;
import org.jasypt.util.text.TextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JuSecurityUtils {
    private static final RegexUtil ENCRYPTION_REGEX = new RegexUtil("ENC\\((.*)\\)");

    public static EncryptorBuilder buildEncryptor() {
        return new EncryptorBuilder();
    }

    public static EncryptionBuilder performEncryption() {
        return new EncryptionBuilder();
    }

    public static String decryptTaggedValueIfNecessary(String value, JuTextEncryptor encryptor) {
        if (encryptor != null && JuSecurityUtils.isEncryptedByTag(value)) {
            String encryptedMessage = ENCRYPTION_REGEX.getMatches(value)[0].getGroups()[0];
            return encryptor.decrypt(encryptedMessage);
        }
        return value;
    }

    public static boolean isEncryptedByTag(String value) {
        return ENCRYPTION_REGEX.matches(value);
    }

    private static JuTextEncryptor asJuTextEncryptor(final TextEncryptor encryptor) {
        return new JuTextEncryptor(){

            @Override
            public String decrypt(String encryptedMessage) {
                return encryptor.decrypt(encryptedMessage);
            }

            @Override
            public String encrypt(String message) {
                return encryptor.encrypt(message);
            }
        };
    }

    public static final class EncryptionBuilder {
        private Logger logger = LoggerFactory.getLogger(EncryptionBuilder.class);
        public static char DEFAULT_CSV_DELIMITER = (char)59;
        private URL sourceUrl;
        private String unencryptedString;
        private JuTextEncryptor encryptor;
        private List<EncryptionToken> encryptionTokens;
        private boolean outputDebugMessages = false;
        private RegexUtil doEncRegex = new RegexUtil("\\s*doENC\\((.+)\\)\\s*");

        public EncryptionBuilder outputDebugMessages() {
            this.outputDebugMessages = true;
            return this;
        }

        public EncryptionBuilder propertyFile(URL propertyFile) throws JuException {
            AssertUtil.assertNull("Source has already been defined", this.encryptionTokens);
            this.sourceUrl = propertyFile;
            this.unencryptedString = new IOUtil().loadTextFromUrl(propertyFile, new String[0]);
            this.encryptionTokens = new ArrayList<EncryptionToken>();
            try (StringReader propReader = new StringReader(this.unencryptedString);){
                Properties props = new Properties();
                props.load(propReader);
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String val = props.getProperty(names.nextElement().toString());
                    this.processUnencryptedValue(val, val);
                }
            }
            catch (IOException ex) {
                throw new JuException("Couldn't load properties", ex);
            }
            return this;
        }

        private void processUnencryptedValue(String unescapedValue, String escapedValue) {
            if (this.doEncRegex.matches(unescapedValue)) {
                String unencryptedValue = this.doEncRegex.getMatches(unescapedValue)[0].getGroups()[0];
                this.encryptionTokens.add(new EncryptionToken(escapedValue, unencryptedValue));
            }
        }

        public EncryptionBuilder csvFile(URL csvFile) throws JuException {
            AssertUtil.assertNull("Source has already been defined", this.encryptionTokens);
            this.sourceUrl = csvFile;
            this.unencryptedString = new IOUtil().loadTextFromUrl(csvFile, new String[0]);
            this.encryptionTokens = new ArrayList<EncryptionToken>();
            try (BufferedReader urlReader = new IOUtil().createReader(csvFile);
                 CSVReader csvReader = new CSVReader((Reader)urlReader, DEFAULT_CSV_DELIMITER);){
                List allEntries = csvReader.readAll();
                Iterator iterator = allEntries.iterator();
                while (iterator.hasNext()) {
                    String[] line;
                    for (String cell : line = (String[])iterator.next()) {
                        String escapedCell = cell.replaceAll("\"", "\"\"");
                        this.processUnencryptedValue(cell, escapedCell);
                    }
                }
            }
            catch (IOException ex) {
                throw new JuException("Error reading CSV File", ex);
            }
            return this;
        }

        public EncryptionBuilder encryptor(JuTextEncryptor encryptor) {
            this.encryptor = encryptor;
            return this;
        }

        private String getEncryptedToken(String encryptedVal) {
            return String.format("ENC(%s)", encryptedVal);
        }

        public String encryptToString() throws JuException {
            AssertUtil.assertNotNull("No resource to encrypt specified", this.encryptionTokens);
            AssertUtil.assertNotNull("No encryptor to encrypt specified", this.encryptor);
            String encryptedString = this.unencryptedString;
            for (EncryptionToken token : this.encryptionTokens) {
                String encryptedValue = this.encryptor.encrypt(token.unencryptedValue);
                String newEncryptedString = encryptedString.replaceFirst(Pattern.quote(token.originalToken), this.getEncryptedToken(encryptedValue));
                if (newEncryptedString.equals(encryptedString)) {
                    throw new JuException("Couldn't replace token: %s", token.unencryptedValue);
                }
                encryptedString = newEncryptedString;
                if (!this.outputDebugMessages) continue;
                this.logger.info("Encrypted token {}. Encrypted Value: {}", (Object)token.originalToken, (Object)encryptedValue);
            }
            return encryptedString;
        }

        public void encryptToSourceFile() throws JuException {
            this.encryptToSourceFile(null);
        }

        public Path encryptToSourceFileWithBackup() throws JuException {
            Path srcFile = JuUrl.toPath(this.sourceUrl);
            Path backup = srcFile.getParent().resolve(srcFile.getFileName().toString() + "_backup_" + JuStringUtils.TIMESTAMP_FORMAT_SECONDS.format(new Date()));
            this.encryptToSourceFile(backup);
            return backup;
        }

        private void encryptToSourceFile(Path backupFile) throws JuException {
            Path sourceFile = JuUrl.toPath(this.sourceUrl);
            if (backupFile != null) {
                IOUtil.copyFile(sourceFile, backupFile, false);
            }
            String encryptedString = this.encryptToString();
            new IOUtil().writeTextToFile(encryptedString, sourceFile, true);
        }

        private static final class EncryptionToken {
            private String originalToken;
            private String unencryptedValue;

            private EncryptionToken(String originalToken, String unencryptedValue) {
                this.originalToken = originalToken;
                this.unencryptedValue = unencryptedValue;
            }
        }
    }

    public static final class EncryptorBuilder {
        private boolean strongEncryption = false;
        private String password;

        public EncryptorBuilder strong() {
            return this.strong(true);
        }

        public EncryptorBuilder strong(boolean strong) {
            this.strongEncryption = strong;
            return this;
        }

        public EncryptorBuilder password(String password) {
            this.password = password;
            return this;
        }

        public EncryptorBuilder passwordByUrl(URL keyFile) {
            try {
                String password = new IOUtil().loadTextFromUrl(keyFile, new String[0]);
                AssertUtil.assertNotEmpty("Encryption password must not be empty", password);
                return this.password(password.trim());
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't load password from resource %s", (Throwable)ex, keyFile);
            }
        }

        public JuTextEncryptor createTextEncryptor() {
            AssertUtil.assertFalse("Password must be set", StringUtils.isEmpty((CharSequence)this.password));
            if (this.strongEncryption) {
                StrongTextEncryptor encryptor = new StrongTextEncryptor();
                encryptor.setPassword(this.password);
                return JuSecurityUtils.asJuTextEncryptor((TextEncryptor)encryptor);
            }
            BasicTextEncryptor encryptor = new BasicTextEncryptor();
            encryptor.setPassword(this.password);
            return JuSecurityUtils.asJuTextEncryptor((TextEncryptor)encryptor);
        }
    }
}

