/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.libs;

import ch.inftec.ju.util.JuStringUtils;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Formatter;
import java.util.IllegalFormatConversionException;
import org.junit.Assert;
import org.junit.Test;

public class JavaTest {
    private boolean wasClosed = false;

    @Test
    public void instanceOf() {
        Assert.assertTrue((boolean)(new Integer(1) instanceof Integer));
        Assert.assertTrue((boolean)("Test" instanceof String));
        Assert.assertTrue((boolean)("Test" instanceof Object));
        Assert.assertFalse((boolean)(null instanceof String));
        Assert.assertFalse((boolean)(null instanceof Object));
    }

    @Test
    public void j7try() {
        this.wasClosed = false;
        try (MyClass c = new MyClass();){
            Assert.assertFalse((boolean)this.wasClosed);
        }
        Assert.assertTrue((boolean)this.wasClosed);
        this.wasClosed = false;
        boolean hadException = false;
        try {
            MyClass c = new MyClass();
            Throwable throwable = null;
            try {
                try {
                    Assert.assertFalse((boolean)this.wasClosed);
                    throw new Exception("Fail");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (c != null) {
                    if (throwable != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        c.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (Exception ex) {
            hadException = true;
            Assert.assertTrue((boolean)this.wasClosed);
            Assert.assertTrue((boolean)hadException);
            this.wasClosed = false;
            hadException = false;
            try (MyClass c = new MyClass(true);){
                Assert.fail((String)"Shouldn't reach here");
            }
            catch (Exception ex2) {
                hadException = true;
            }
            Assert.assertFalse((boolean)this.wasClosed);
            Assert.assertTrue((boolean)hadException);
            return;
        }
    }

    @Test
    public void stringFormat() {
        Assert.assertEquals((Object)"X-00005", (Object)String.format("X-%05d", 5L));
        Assert.assertEquals((Object)"X-123456", (Object)String.format("X-%05d", 123456L));
    }

    @Test
    public void formatter() throws Exception {
        Formatter f = new Formatter();
        Assert.assertEquals((Object)"Hello World", (Object)f.format("Hello %s", "World").toString());
        Assert.assertEquals((Object)"Hello World", (Object)String.format("Hello %s", "World"));
        System.out.printf("Hello %s", "World");
        Assert.assertEquals((Object)"Hello World", (Object)String.format("%2$s %1$s", "World", "Hello"));
        Assert.assertEquals((Object)"Hello", (Object)String.format("%2$s", "World", "Hello"));
        Assert.assertEquals((Object)"B B A A B B C", (Object)String.format("%2$s %<s %1$s %s %s %<s %s", "A", "B", "C"));
        Assert.assertEquals((Object)"A C B B C", (Object)String.format("%s %3$s %s %<s %s", "A", "B", "C"));
        Assert.assertEquals((Object)"a", (Object)String.format("%s", "a"));
        Assert.assertEquals((Object)"A", (Object)String.format("%S", "a"));
        Assert.assertEquals((Object)"null", (Object)String.format("%s", new Object[]{null}));
        Assert.assertEquals((Object)"false", (Object)String.format("%b", false));
        Assert.assertEquals((Object)"17", (Object)String.format("%d", 17));
        Assert.assertEquals((Object)"11", (Object)String.format("%h", 17));
        Assert.assertEquals((Object)"null", (Object)String.format("%h", new Object[]{null}));
        Assert.assertEquals((Object)"340282346638528860000000000000000000000.000000", (Object)String.format("%f", Float.valueOf(Float.MAX_VALUE)));
        Assert.assertEquals((Object)"3.40282e+38", (Object)String.format("%g", Float.valueOf(Float.MAX_VALUE)));
        Assert.assertEquals((Object)"0x1.fffffep127", (Object)String.format("%a", Float.valueOf(Float.MAX_VALUE)));
        try {
            Assert.assertEquals((Object)"", (Object)String.format("%f", 17L));
            Assert.fail((String)"Not expected...");
        }
        catch (IllegalFormatConversionException ex) {
            Assert.assertEquals((Object)"f != java.lang.Long", (Object)ex.getMessage());
        }
        Date d = JuStringUtils.DATE_FORMAT_SECONDS.parse("01.02.2003 11:12:13");
        Assert.assertEquals((Object)"2003-02-01", (Object)String.format("%tF", d));
        Assert.assertEquals((Object)"11.12", (Object)String.format("%1$tH.%1$tM", d));
        Assert.assertEquals((Object)"Hello      World", (Object)String.format("%-10s %s", "Hello", "World"));
        Assert.assertEquals((Object)"     Hello World", (Object)String.format("%10s %s", "Hello", "World"));
        Assert.assertEquals((Object)"Hello", (Object)String.format("%1s", "Hello"));
        Assert.assertEquals((Object)" 17", (Object)String.format("%3d", 17));
        Assert.assertEquals((Object)"17.00", (Object)String.format("%3.2f", Float.valueOf(17.0f)));
        Assert.assertEquals((Object)" 1.0", (Object)String.format("%4.1f", Float.valueOf(1.0f)));
        Assert.assertEquals((Object)"017", (Object)String.format("%03d", 17));
        Assert.assertEquals((Object)"+17", (Object)String.format("%+d", 17));
        Assert.assertEquals((Object)"(17)", (Object)String.format("%(d", -17));
    }

    @Test
    public void weakReference() {
        Long[] largeObject = new Long[100000];
        ReferenceQueue queue = new ReferenceQueue();
        WeakReference<Long[]> ref = new WeakReference<Long[]>(largeObject, queue);
        Assert.assertSame((Object)largeObject, ref.get());
        largeObject = null;
        System.gc();
        Assert.assertNull(ref.get());
    }

    @Test
    public void instanceInitializer() {
        InstanceInitializerClass c = new InstanceInitializerClass();
        Assert.assertEquals((long)2L, (long)c.x);
    }

    @Test
    public void instanceInitializer_anonymous() {
        InstanceInitializerClass c = new InstanceInitializerClass(){
            {
                this.x = 3;
            }
        };
        Assert.assertEquals((long)3L, (long)c.x);
    }

    @Test
    public void arrayInizialization() {
        int[] a1 = new int[]{1, 2};
        Assert.assertEquals((long)1L, (long)a1[0]);
        int[] a2 = new int[]{1, 2};
        Assert.assertEquals((long)1L, (long)a2[0]);
        int[] a3 = new int[2];
        Assert.assertEquals((long)0L, (long)a3[0]);
    }

    @Test
    public void arrayInitialization_multiDimension() {
        int[][][] a1 = new int[1][][];
        Assert.assertNull((Object)a1[0]);
        int[][] a2 = new int[][]{{0, 1}, {2, 3}};
        Assert.assertEquals((long)3L, (long)a2[1][1]);
        int[][] a2b = new int[][]{{0, 1}, {2, 3}};
        int[][] a2c = new int[][]{{0, 1}, {2, 3}};
        Assert.assertEquals((long)3L, (long)a2b[1][1]);
        Assert.assertEquals((long)3L, (long)a2c[1][1]);
    }

    @Test
    public void validIdentifiers() {
    }

    @Test
    public void dataTypes() {
        int b = 3;
        int c1 = 7;
        int c2 = 97;
        int i = b + c1 + c2;
        Assert.assertEquals((long)107L, (long)i);
    }

    @Test
    public void implicitNarrowing() {
        boolean b = true;
        char c = (char)(b ? 1 : 0);
        boolean bFinal = true;
        boolean c2 = true;
        long lFinal = 1L;
        boolean iFinal = true;
        boolean s = true;
    }

    private class InstanceInitializerClass {
        int x = 2;

        InstanceInitializerClass() {
        }
    }

    private class MyClass
    implements AutoCloseable {
        public MyClass() {
            this(false);
        }

        public MyClass(boolean fail) {
            if (fail) {
                throw new RuntimeException("Failed");
            }
        }

        @Override
        public void close() {
            JavaTest.this.wasClosed = true;
        }
    }
}

