/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.helper;

import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.TestUtils;
import ch.inftec.ju.util.helper.FindHelper;
import ch.inftec.ju.util.helper.FindHelperBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FindHelperTest {
    private List<Integer> empty = Collections.emptyList();
    private List<Integer> one = JuCollectionUtils.asArrayList((Object[])new Integer[]{1});
    private List<Integer> two = JuCollectionUtils.asArrayList((Object[])new Integer[]{1, 2});
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void one_throwsException_forEmpty() {
        this.exception.expectMessage("No element available");
        FindHelper findHelper = new FindHelperBuilder().iterable(this.empty).createFindHelper();
        findHelper.one();
    }

    @Test
    public void one_throwsException_forTwo() {
        this.exception.expectMessage("More than 1 item available");
        FindHelper findHelper = new FindHelperBuilder().iterable(this.two).createFindHelper();
        findHelper.one();
    }

    @Test
    public void one_findsOne() {
        FindHelper findHelper = new FindHelperBuilder().iterable(this.one).createFindHelper();
        Assert.assertEquals((Object)new Integer(1), (Object)findHelper.one());
    }

    @Test
    public void oneOrNull_findsOne() {
        FindHelper findHelper = new FindHelperBuilder().iterable(this.one).createFindHelper();
        Assert.assertEquals((Object)new Integer(1), (Object)findHelper.oneOrNull());
    }

    @Test
    public void oneOrNull_returnsNull_forEmpty() {
        FindHelper findHelper = new FindHelperBuilder().iterable(this.empty).createFindHelper();
        Assert.assertNull((Object)findHelper.oneOrNull());
    }

    @Test
    public void all_findsAll() {
        FindHelper findHelper = new FindHelperBuilder().iterable(this.two).createFindHelper();
        TestUtils.assertCollectionConsistsOfAll((Collection)findHelper.all(), (Object[])new Integer[]{1, 2});
    }
}

