/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.general;

import ch.inftec.ju.util.event.JuEventUtils;
import ch.inftec.ju.util.general.Descriptor;
import ch.inftec.ju.util.general.DescriptorUtils;
import java.util.EventListener;
import org.junit.Assert;
import org.junit.Test;

public class DescriptorTest {
    private String evaluatorDescription;

    @Test
    public void descriptor() {
        Descriptor d = DescriptorUtils.newInstance((String)"Name", (String)"Description");
        Assert.assertEquals((Object)"Name", (Object)d.getName());
        Assert.assertEquals((Object)"Description", (Object)d.getDescription());
        Assert.assertEquals((Object)"Name", (Object)d.toString());
    }

    @Test
    public void descriptorBuilder() {
        Descriptor d = DescriptorUtils.builder((String)"Name").description("Description").setObject(Integer.class, (Object)1).setObject(Long.class, (Object)2L).getDescriptor();
        Assert.assertEquals((Object)"Name", (Object)d.getName());
        Assert.assertEquals((Object)"Description", (Object)d.getDescription());
        Assert.assertEquals((Object)"Name", (Object)d.toString());
        Assert.assertEquals((Object)1, (Object)d.getObject(Integer.class));
        Assert.assertEquals((Object)2L, (Object)d.getObject(Long.class));
    }

    @Test
    public void descripionEvaluator() {
        DescriptorUtils.AbstractDescriptionEvaluator descriptionEvaluator = new DescriptorUtils.AbstractDescriptionEvaluator(){

            protected String evaluateDescription() {
                return DescriptorTest.this.evaluatorDescription;
            }
        };
        Descriptor d = DescriptorUtils.builder((String)"Name").description("1").evaluator((DescriptorUtils.DescriptionEvaluator)descriptionEvaluator).getDescriptor();
        this.evaluatorDescription = "2";
        Assert.assertEquals((Object)"2", (Object)d.getDescription());
        this.evaluatorDescription = "3";
        Assert.assertEquals((Object)"2", (Object)d.getDescription());
        descriptionEvaluator.updateDescription();
        Assert.assertEquals((Object)"3", (Object)d.getDescription());
        JuEventUtils.TestUpdateListener testListener = JuEventUtils.newTestUpdateListener();
        d.getUpdateNotifier().addListener((EventListener)testListener);
        this.evaluatorDescription = "4";
        descriptionEvaluator.updateDescription();
        Assert.assertEquals((Object)"4", (Object)d.getDescription());
        testListener.assertOneCall();
    }
}

