/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.event;

import ch.inftec.ju.util.event.EventNotifier;
import ch.inftec.ju.util.event.JuEventObject;
import ch.inftec.ju.util.event.JuEventUtils;
import ch.inftec.ju.util.event.UpdateListener;
import java.util.EventListener;
import org.junit.Assert;
import org.junit.Test;

public class EventTest {
    private boolean weakCalled = false;
    private boolean strongCalled = false;

    @Test
    public void updateEventNotifier() {
        JuEventUtils.UpdateEventNotifier eventNotifier = JuEventUtils.newUpdateEventNotifier();
        eventNotifier.fireUpdateEvent((Object)new EventSender(0));
        JuEventUtils.TestUpdateListener updateListener = JuEventUtils.newTestUpdateListener();
        eventNotifier.addListener((EventListener)updateListener);
        eventNotifier.fireUpdateEvent((Object)new EventSender(1));
        updateListener.assertOneCall();
        Assert.assertEquals((long)1L, (long)((EventSender)updateListener.getLastSource()).val);
        UpdateListener<EventSender> weakListener = new UpdateListener<EventSender>(){

            public void updated(JuEventObject<EventSender> event) {
                EventTest.this.weakCalled = true;
            }
        };
        UpdateListener<EventSender> strongListener = new UpdateListener<EventSender>(){

            public void updated(JuEventObject<EventSender> event) {
                EventTest.this.strongCalled = true;
            }
        };
        eventNotifier.addListener((EventListener)strongListener);
        eventNotifier.addWeakListener((EventListener)weakListener);
        Assert.assertFalse((boolean)this.weakCalled);
        Assert.assertFalse((boolean)this.strongCalled);
        eventNotifier.fireUpdateEvent((Object)new EventSender(0));
        Assert.assertTrue((boolean)this.weakCalled);
        Assert.assertTrue((boolean)this.strongCalled);
        strongListener = null;
        weakListener = null;
        System.gc();
        this.strongCalled = false;
        this.weakCalled = false;
        eventNotifier.fireUpdateEvent((Object)new EventSender(0));
        Assert.assertFalse((boolean)this.weakCalled);
        Assert.assertTrue((boolean)this.strongCalled);
    }

    @Test
    public void testUpdateListener() {
        JuEventUtils.TestUpdateListener updateListener = JuEventUtils.newTestUpdateListener();
        Assert.assertNull((Object)updateListener.getLastSource());
        Assert.assertEquals((long)0L, (long)updateListener.getCalls());
        updateListener.updated(new JuEventObject((Object)new EventSender(0)));
        updateListener.updated(new JuEventObject((Object)new EventSender(1)));
        Assert.assertEquals((long)2L, (long)updateListener.getCalls());
        updateListener.updated(null);
        updateListener.updated(null);
        try {
            updateListener.assertOneCall();
            Assert.fail((String)"Was called twice");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void testForwardUpdateEvents() {
        JuEventUtils.TestUpdateListener updateListener = JuEventUtils.newTestUpdateListener();
        JuEventUtils.UpdateEventNotifier eventSource = JuEventUtils.newUpdateEventNotifier();
        JuEventUtils.UpdateEventNotifier eventTarget = JuEventUtils.newUpdateEventNotifier();
        eventTarget.addListener((EventListener)updateListener);
        eventSource.fireUpdateEvent((Object)new EventSender(0));
        updateListener.assertNoCall();
        Object forwardingRef = JuEventUtils.forwardUpdateEvents((EventNotifier)eventSource, (JuEventUtils.UpdateEventNotifier)eventTarget, (Object)"Hello", (boolean)false);
        Assert.assertNotNull((Object)forwardingRef);
        JuEventUtils.forwardUpdateEvents((EventNotifier)eventSource, (JuEventUtils.UpdateEventNotifier)eventTarget, (Object)"Hello", (boolean)true);
        eventSource.fireUpdateEvent((Object)new EventSender(0));
        Assert.assertEquals((long)2L, (long)updateListener.resetCalls());
        System.gc();
        eventSource.fireUpdateEvent((Object)new EventSender(0));
        Assert.assertEquals((long)2L, (long)updateListener.resetCalls());
        forwardingRef = null;
        System.gc();
        eventSource.fireUpdateEvent((Object)new EventSender(0));
        Assert.assertEquals((Object)"Hello", (Object)updateListener.assertOneCall());
    }

    private static class EventSender {
        int val;

        EventSender(int val) {
            this.val = val;
        }
    }
}

