/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.comparison;

import ch.inftec.ju.util.comparison.DefaultComparator;
import ch.inftec.ju.util.comparison.ValueComparator;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class ComparisonTest {
    @Test
    public void valueComparatorEquals() {
        ValueComparator cObj = ValueComparator.INSTANCE;
        Assert.assertTrue((boolean)cObj.equals(null, null));
        Assert.assertFalse((boolean)cObj.equals(null, (Object)"something"));
        Assert.assertFalse((boolean)cObj.equals((Object)"something", null));
        Assert.assertTrue((boolean)cObj.equals((Object)new BigDecimal(8), (Object)8));
        Assert.assertTrue((boolean)cObj.equals((Object)new BigDecimal(8), (Object)8L));
        Assert.assertTrue((boolean)cObj.equals((Object)8, (Object)new BigDecimal(8)));
        Assert.assertTrue((boolean)cObj.equals((Object)8, (Object)8L));
        Assert.assertTrue((boolean)cObj.equals((Object)8.2, (Object)Float.valueOf(8.2f)));
        Assert.assertTrue((boolean)cObj.equals((Object)"Test", (Object)"Test"));
    }

    @Test
    public void defaultComparatorEquals() {
        DefaultComparator cObj = new DefaultComparator();
        Assert.assertTrue((boolean)cObj.equals(null, null));
        Assert.assertFalse((boolean)cObj.equals(null, (Object)"something"));
        Assert.assertFalse((boolean)cObj.equals((Object)"something", null));
        Assert.assertTrue((boolean)cObj.equals((Object)1, (Object)1));
        Assert.assertFalse((boolean)cObj.equals((Object)1, (Object)1L));
        Assert.assertFalse((boolean)cObj.equals((Object)1, (Object)"test"));
        Assert.assertFalse((boolean)cObj.equals(new Object(), new Object()));
    }

    @Test
    public void defaultComparatorCompareTo() {
        DefaultComparator cObj = new DefaultComparator();
        Assert.assertTrue((cObj.compare(null, null) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((cObj.compare(null, "something") == -1 ? 1 : 0) != 0);
        Assert.assertTrue((cObj.compare("something", null) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((cObj.compare(1, 1) == 0 ? 1 : 0) != 0);
        try {
            cObj.compare(1L, 1);
            Assert.fail((String)"Expected Class-Cast-Exception");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void compare() {
    }
}

