/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.collection;

import ch.inftec.ju.util.collection.Cache;
import ch.inftec.ju.util.collection.SimpleCache;
import ch.inftec.ju.util.function.Function;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SimpleCacheTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private Cache<String, String> cache = new SimpleCache(2, (Function)new Function<String, String>(){

        public String apply(String s) {
            return s + "_val";
        }
    });

    @Test
    public void unexistingValue_newValue_isAdded() {
        String val = (String)this.cache.get((Object)"k1");
        Assert.assertEquals((Object)"k1_val", (Object)val);
        Assert.assertEquals((long)1L, (long)this.cache.size());
    }

    @Test
    public void valueIsPut_get_returnsValue() {
        this.cache.put((Object)"k1", (Object)"v1");
        Assert.assertEquals((Object)"v1", (Object)this.cache.get((Object)"k1"));
        Assert.assertEquals((long)1L, (long)this.cache.size());
    }

    @Test
    public void maxSizeReached_putWithNewValue_replacesValue() {
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        this.cache.put((Object)"k3", (Object)"v3");
        Assert.assertEquals((Object)"v3", (Object)this.cache.get((Object)"k3"));
        Assert.assertEquals((long)2L, (long)this.cache.size());
    }

    @Test
    public void maxSizeReached_getWithNewKey_replacesValue() {
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        this.cache.put((Object)"k3", (Object)"v3");
        Assert.assertEquals((Object)"k1_val", (Object)this.cache.get((Object)"k1"));
        Assert.assertEquals((long)2L, (long)this.cache.size());
    }

    @Test
    public void maxSizeReachedNoGet_getWithNewKey_replacesValueFirstPut() {
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        this.cache.put((Object)"k3", (Object)"v3");
        Assert.assertEquals((Object)"k1_val", (Object)this.cache.get((Object)"k1"));
    }

    @Test
    public void maxSizeReachedWithGet_getWithNewKey_replacesValueLongestNotReturned() {
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((Object)"v1", (Object)this.cache.get((Object)"k1"));
        this.cache.put((Object)"k3", (Object)"v3");
        Assert.assertEquals((Object)"v1", (Object)this.cache.get((Object)"k1"));
    }

    @Test
    public void maxSizeZero_newSimpleCache_throwsException() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("maxSize must be greater than 0, but was 0");
        new SimpleCache(0, (Function)new Function<String, String>(){

            public String apply(String s) {
                return null;
            }
        });
    }
}

