/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.TestUtils;
import ch.inftec.ju.util.xml.XmlUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.w3c.dom.Document;

public class TestUtilsTest {
    private static boolean doTestFail = false;

    @Test
    public void canRunJUnitTests() {
        SuccessfulTest.run = false;
        TestUtils.runJUnitTests(SuccessfulTest.class);
        Assert.assertTrue((boolean)SuccessfulTest.run);
    }

    @Test(expected=JuRuntimeException.class)
    public void failingTests_fail() {
        try {
            doTestFail = true;
            TestUtils.runJUnitTests(FailingTest.class);
        }
        finally {
            doTestFail = false;
        }
    }

    @Test
    public void canCompare_xmlDocument_toResource() {
        Document doc = XmlUtils.buildXml((String)"root").addChild("child").endChild().getDocument();
        TestUtils.assertEqualsXmlResource((String)"TestUtilsTest_canCompare_xmlDocument_toResource.xml", (Document)doc);
    }

    @Test
    public void canCompare_xml_toResource() {
        String xml = "<root><child/></root>";
        TestUtils.assertEqualsXmlResource((String)"TestUtilsTest_canCompare_xmlDocument_toResource.xml", (String)xml);
    }

    @Test
    public void assertion_canCompare_xml() {
        String xml = "<root><child/></root>";
        TestUtils.assertion().xml().expectedResource(JuUrl.existingResourceRelativeToAndPrefixed((String)"canCompare_xmlDocument_toResource.xml", this.getClass())).actualXml(xml).assertEquals();
    }

    @Test(expected=Throwable.class)
    public void assertion_withUnequalXml_throwsError() {
        String xml = "<root><child2/></root>";
        TestUtils.assertion().xml().expectedResource(JuUrl.existingResourceRelativeToAndPrefixed((String)"canCompare_xmlDocument_toResource.xml", this.getClass())).actualXml(xml).assertEquals();
    }

    @Test
    public void assertion_canExport_xml() {
        String xml = "<root/>";
        Path exportPath = Paths.get("target/TestUtilsTest_assertion_canExport_xml.xml", new String[0]);
        IOUtil.deleteFile((Path)exportPath);
        ((TestUtils.AssertionBuilder.XmlAssertionBuilder)TestUtils.assertion().xml().actualXml(xml).export().enable(true).exportFilePath(exportPath).done()).assertEquals();
        Assert.assertTrue((boolean)IOUtil.exists().file(exportPath));
        String exportedXml = new IOUtil().loadTextFromUrl(JuUrl.toUrl((Path)exportPath), new String[0]);
        Assert.assertEquals((Object)xml, (Object)exportedXml);
        IOUtil.deleteFile((Path)exportPath);
    }

    public static class FailingTest {
        @Test
        public void throw_juRuntimeException() {
            Assume.assumeTrue((boolean)doTestFail);
            throw new JuRuntimeException("failing");
        }
    }

    public static class SuccessfulTest {
        public static boolean run = false;

        @Test
        public void setRun_toTrue() {
            run = true;
        }
    }
}

