/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.XString;
import java.util.Date;
import org.slf4j.Logger;

public final class Timer {
    private Date startTime;
    private long startMemory;
    private Date pauseTime;
    private Long pauseMemory;
    private final Logger logger;

    public Timer(Logger logger, String description) {
        this(logger, description, null);
    }

    public Timer(Logger logger, String description, Date startTime) {
        this.logger = logger;
        this.startTime = startTime == null ? new Date() : startTime;
        this.start(description);
    }

    public Timer() {
        this(null, null, null);
    }

    public Timer(Date startTime) {
        this(null, null, startTime);
    }

    private void log(String msg) {
        if (this.logger != null) {
            this.logger.info(msg);
        }
    }

    private void start(String description) {
        this.log(description + ": Started");
        this.startMemory = Runtime.getRuntime().freeMemory();
    }

    public void restart(String description) {
        this.startTime = new Date();
        this.start(description);
    }

    public void stop(String description) {
        if (this.logger != null) {
            this.logger.info(description + ": " + this.getElapsedString());
        }
    }

    void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getCurrentTime() {
        return this.pauseTime != null ? this.pauseTime : new Date();
    }

    public void pause() {
        this.pauseTime = new Date();
        this.pauseMemory = Runtime.getRuntime().freeMemory();
    }

    public void resume() {
        this.pauseTime = null;
        this.pauseMemory = null;
    }

    public long getElapsedMillis() {
        return this.getCurrentTime().getTime() - this.startTime.getTime();
    }

    public String getElapsedString() {
        long elapsedMillis;
        long remainingMillis = elapsedMillis = this.getElapsedMillis();
        long hours = remainingMillis / 1000L / 60L / 60L;
        long minutes = (remainingMillis -= hours * 1000L * 60L * 60L) / 1000L / 60L;
        long seconds = (remainingMillis -= minutes * 1000L * 60L) / 1000L;
        long millis = remainingMillis -= seconds * 1000L;
        XString s = new XString();
        if (hours > 0L) {
            s.addText(hours, "h ");
        }
        if (hours > 0L || minutes > 0L) {
            if (minutes < 10L) {
                s.addText(" ");
            }
            s.addText(minutes, "m ");
        }
        if (hours > 0L || minutes > 0L || seconds > 0L) {
            if (seconds < 10L) {
                s.addText(" ");
            }
            s.addText(seconds);
        }
        s.addText(".");
        if (millis < 100L) {
            s.addText("0");
        }
        if (millis < 10L) {
            s.addText("0");
        }
        s.addText(millis);
        s.addText("s");
        return s.toString();
    }

    public void memoryUsage(String description) {
        if (this.logger == null) {
            return;
        }
        long memory = this.pauseMemory == null ? Runtime.getRuntime().freeMemory() : this.pauseMemory.longValue();
        long usedMemory = memory - this.startMemory;
        String usedMemoryString = null;
        usedMemoryString = usedMemory > 1000000L ? (float)usedMemory / 1000000.0f + " MBytes" : (usedMemory > 1000L ? (float)usedMemory / 1000.0f + " KBytes" : usedMemory + " Bytes");
        this.logger.info(description + ": " + usedMemoryString);
    }

    public String toString() {
        return this.getElapsedString();
    }
}

