/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.JuException;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.ReflectUtils;
import ch.inftec.ju.util.RegexUtil;
import ch.inftec.ju.util.XString;
import ch.inftec.ju.util.comparison.EqualityTester;
import ch.inftec.ju.util.xml.XmlUtils;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.junit.Assert;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public final class TestUtils {
    private static final Logger logger = LoggerFactory.getLogger(TestUtils.class);

    private TestUtils() {
        throw new AssertionError((Object)"use only statically");
    }

    public static void runInternalTests(Class<?> c, Object ... params) {
        Method m = null;
        try {
            Class<?>[] paramTypes = ReflectUtils.getTypes(params);
            m = ReflectUtils.getDeclaredMethod(c, "internalTests", paramTypes);
            m.setAccessible(true);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Couldn't get static method 'internalTests' for class " + c.getName(), ex);
        }
        try {
            m.invoke(null, params);
        }
        catch (Exception ex) {
            throw new RuntimeException("internalTests raised exception for class " + c.getName(), ex);
        }
    }

    public static Result runJUnitTests(Class<?> clazz) {
        Computer computer = new Computer();
        Result res = new JUnitCore().run(computer, new Class[]{clazz});
        if (res.getFailureCount() > 0) {
            XString xs = new XString("Unit tests failed. Failure count: " + res.getFailureCount());
            for (Failure f : res.getFailures()) {
                xs.addLineFormatted("%s: %s", f.getException().getClass(), f.getException().getMessage());
                logger.error("Unit test failed: " + f.getMessage(), f.getException());
            }
            throw new JuRuntimeException(xs.toString(), ((Failure)res.getFailures().get(0)).getException());
        }
        return res;
    }

    public static void assertEqualsResource(String resourceName, String s, String ... replacements) {
        try {
            String resString = new IOUtil("UTF-8").loadTextFromUrl(JuUrl.resource().exceptionIfNone().relativeTo(ReflectUtils.getCallingClass()).get(resourceName), replacements);
            String sUnix = IOUtil.toNewLineUnix(s);
            Assert.assertEquals((Object)resString, (Object)sUnix);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Resource not found: " + resourceName, ex);
        }
    }

    public static void assertEqualsXmlResource(String xmlResource, Document doc) {
        try {
            Document resourceDoc = XmlUtils.loadXml(JuUrl.resourceRelativeTo(xmlResource, ReflectUtils.getCallingClass()));
            TestUtils.assertEqualsXml(resourceDoc, doc);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't compare XML document to resource", ex);
        }
    }

    public static void assertEqualsXmlResource(String xmlResource, String actualXml) {
        TestUtils.assertEqualsXmlResource(xmlResource, actualXml, ReflectUtils.getCallingClass());
    }

    public static void assertEqualsXmlResource(URL xmlResource, String actualXml) {
        try {
            Document resourceDoc = XmlUtils.loadXml(xmlResource);
            TestUtils.assertEqualsXml(resourceDoc, XmlUtils.loadXml(actualXml, null));
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't compare XML document to resource", ex);
        }
    }

    public static void assertEqualsXmlResource(String xmlResource, String actualXml, Class<?> clazz) {
        URL url = JuUrl.resourceRelativeTo(xmlResource, clazz);
        AssertUtil.assertNotNull(String.format("Couldn't load resource %s [relative to: %s]", xmlResource, clazz), url);
        try {
            Document resourceDoc = XmlUtils.loadXml(url);
            TestUtils.assertEqualsXml(resourceDoc, XmlUtils.loadXml(actualXml, null));
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't compare XML document to resource", ex);
        }
    }

    public static <K, V> void assertMapEquals(Map<K, V> mExpected, Map<K, V> mActual, EqualityTester<V> equalityTester) {
        if (!JuCollectionUtils.mapEquals(mExpected, mActual, equalityTester)) {
            Assert.fail((String)("Maps are not equal. Expected: " + mExpected + "; Actual: " + mActual));
        }
    }

    public static <K, V> void assertMapEquals(Map<K, V> mExpected, Map<K, V> mActual) {
        TestUtils.assertMapEquals(mExpected, mActual, null);
    }

    public static void assertArrayEquals(Object[] aExpected, Object[] aActual) {
        if (!JuCollectionUtils.arrayEquals(aExpected, aActual)) {
            Assert.fail((String)("Arrays are not equal. Expected: " + Arrays.toString(aExpected) + "; Actual: " + Arrays.toString(aActual)));
        }
    }

    public static <T> void assertCollectionEquals(Collection<? extends T> cExpected, Collection<? extends T> cActual) {
        if (!JuCollectionUtils.collectionEquals(cExpected, cActual)) {
            Assert.fail((String)("Collections are not equal. Expected: " + cExpected + "; Actual: " + cActual));
        }
    }

    @SafeVarargs
    public static <T> void assertCollectionEquals(Collection<? extends T> cActual, T ... expectedObjects) {
        TestUtils.assertCollectionEquals(Arrays.asList(expectedObjects), cActual);
    }

    public static void assertRegexEquals(String expectedPattern, String actualString) {
        if (!new RegexUtil(expectedPattern).matches(actualString)) {
            Assert.fail((String)("String doesn't match pattern. Expected: " + expectedPattern + "; Actual: " + actualString));
        }
    }

    public static void assertEqualsXml(Document expectedDocument, Document actualDocument) {
        String expectedXml = XmlUtils.toString(expectedDocument, false, true);
        String actualXml = XmlUtils.toString(actualDocument, false, true);
        Assert.assertEquals((Object)expectedXml, (Object)actualXml);
    }

    @SafeVarargs
    public static <T> void assertCollectionContains(Collection<? extends T> cCollection, T ... values) {
        for (T val : values) {
            if (cCollection.contains(val)) continue;
            Assert.fail((String)("Value not part of collection: " + val));
        }
    }

    @SafeVarargs
    public static <T> void assertCollectionConsistsOfAll(Collection<? extends T> collection, T ... values) {
        ArrayList<T> c = new ArrayList<T>(collection);
        for (T val : values) {
            if (c.remove(val)) {
                while (c.remove(val)) {
                }
                continue;
            }
            Assert.fail((String)("Element not found in collection: " + val));
        }
        if (c.size() > 0) {
            Assert.fail((String)("Collection contains other than the specified values: " + c));
        }
    }

    public static Method getTestMethod(Description description) {
        Class testClass = description.getTestClass();
        AssertUtil.assertNotNull("Description must contain test class", testClass);
        String testMethod = description.getMethodName();
        AssertUtil.assertNotNull("Description must contain test method name", testMethod);
        if (testMethod.contains("[")) {
            testMethod = testMethod.substring(0, testMethod.indexOf("["));
        }
        Method method = ReflectUtils.getMethod(testClass, testMethod, null);
        AssertUtil.assertNotNull(String.format("Couldn't get method using reflection: %s.%s", testClass, testMethod), method);
        return method;
    }

    public static AssertionBuilder assertion() {
        return new AssertionBuilder();
    }

    public static final class AssertionBuilder {
        private AssertionBuilder() {
        }

        public XmlAssertionBuilder xml() {
            return new XmlAssertionBuilder();
        }

        public static final class XmlAssertionBuilder {
            private URL expectedResourceUrl;
            private String actualXml;
            private final ExportBuilder<XmlAssertionBuilder> exportBuilder = new ExportBuilder(this);

            private XmlAssertionBuilder() {
            }

            public XmlAssertionBuilder expectedResource(URL url) {
                this.expectedResourceUrl = url;
                return this;
            }

            public XmlAssertionBuilder actualXml(String xml) {
                this.actualXml = xml;
                return this;
            }

            public void assertEquals() {
                AssertUtil.assertNotNull("actualXml must be specified", this.actualXml);
                if (((ExportBuilder)this.exportBuilder).enabled) {
                    Path exportFilePath = ((ExportBuilder)this.exportBuilder).exportFilePath;
                    AssertUtil.assertNotNull("exportFilePath must be specified", exportFilePath);
                    logger.debug("Exporting actualXml to file: " + exportFilePath);
                    try {
                        new IOUtil().writeTextToFile(this.actualXml, exportFilePath, true);
                    }
                    catch (JuException ex) {
                        throw new JuRuntimeException("Couldn't write actual XML to %s:\n%s", (Throwable)ex, exportFilePath, this.actualXml);
                    }
                } else {
                    AssertUtil.assertNotNull("expectedResource must be specified", this.expectedResourceUrl);
                    TestUtils.assertEqualsXmlResource(this.expectedResourceUrl, this.actualXml);
                }
            }

            public ExportBuilder<XmlAssertionBuilder> export() {
                return this.exportBuilder;
            }

            public static final class ExportBuilder<T> {
                private final T returnTo;
                private boolean enabled = false;
                private Path exportFilePath;

                private ExportBuilder(T returnTo) {
                    this.returnTo = returnTo;
                }

                public ExportBuilder<T> enable(boolean enabled) {
                    this.enabled = enabled;
                    return this;
                }

                public ExportBuilder<T> exportFilePath(Path exportFilePath) {
                    this.exportFilePath = exportFilePath;
                    return this;
                }

                public T done() {
                    return this.returnTo;
                }
            }
        }
    }
}

