/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.XString;
import java.util.ArrayList;
import org.apache.commons.lang3.reflect.FieldUtils;

public class JuBeanUtils {
    public static void checkFieldsNotNull(Object obj, String ... fieldNames) {
        ArrayList<String> nullFields = new ArrayList<String>();
        ArrayList<String> errorFields = new ArrayList<String>();
        for (String fieldName : fieldNames) {
            try {
                Object res = FieldUtils.readField((Object)obj, (String)fieldName, (boolean)true);
                if (res != null) continue;
                nullFields.add(fieldName);
            }
            catch (IllegalAccessException ex) {
                errorFields.add(fieldName);
            }
        }
        if (nullFields.size() > 0 || errorFields.size() > 0) {
            XString xs = new XString("Fields must be set: ");
            xs.addItems(", ", nullFields.toArray());
            if (errorFields.size() > 0) {
                xs.addText(". Failed to access fields: ");
                xs.addItems(", ", errorFields.toArray());
            }
            throw new IllegalStateException(xs.toString());
        }
    }
}

