/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.JuException;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.function.Predicate;
import ch.inftec.ju.util.function.Predicates;
import ch.inftec.ju.util.io.NewLineReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtil {
    static final Logger log = LoggerFactory.getLogger(IOUtil.class);
    private static String defaultCharset = null;
    private static int tempFileCounter = 0;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final String charset;

    public static synchronized String getDefaultCharset() {
        if (defaultCharset == null) {
            defaultCharset = Charset.defaultCharset().displayName();
        }
        return defaultCharset;
    }

    public static synchronized void setDefaultCharset(String charset) {
        defaultCharset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public IOUtil() {
        this(IOUtil.getDefaultCharset());
    }

    public IOUtil(String charset) {
        this.charset = charset;
    }

    public static void close(Reader reader) {
        try {
            log.debug("Closing Reader: " + ObjectUtils.identityToString((Object)reader));
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException ex) {
            log.warn("Could not close Reader instance: " + ex.getMessage());
        }
    }

    public static void close(InputStream stream) {
        try {
            log.debug("Closing InputStream: " + ObjectUtils.identityToString((Object)stream));
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ex) {
            log.warn("Could not close InputStream instance: " + ex.getMessage());
        }
    }

    public static void close(OutputStream stream) {
        try {
            log.debug("Closing OutputStream: " + ObjectUtils.identityToString((Object)stream));
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ex) {
            log.warn("Could not close OutputStream instance: " + ex.getMessage());
        }
    }

    public static String toString(Reader reader) {
        StringWriter stringWriter = new StringWriter();
        try {
            IOUtil.copy(reader, stringWriter);
            return stringWriter.toString();
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't generate String for Reader", ex);
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = IOUtil.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static int copy(Reader input, Writer output) throws IOException {
        long count = IOUtil.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        int n;
        char[] buffer = new char[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static String toNewLineUnix(String s) {
        if (s == null) {
            return null;
        }
        NewLineReader reader = new NewLineReader(new StringReader(s), null, LINE_SEPARATOR_UNIX);
        return IOUtil.toString(reader);
    }

    public static synchronized Path getTemporaryFile() throws JuException {
        try {
            Path tempPath = Files.createTempFile(String.format("%s_%s_%s", IOUtil.class.getName(), tempFileCounter++, System.currentTimeMillis()), "tmp", new FileAttribute[0]);
            tempPath.toFile().deleteOnExit();
            return tempPath;
        }
        catch (Exception ex) {
            throw new JuException("Couldn't create temporary file", ex);
        }
    }

    public static boolean deleteFile(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new JuRuntimeException("Not a regular file: " + path);
            }
            try {
                Files.delete(path);
                return true;
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't delete file: " + path, ex);
            }
        }
        return false;
    }

    public static void copyFile(Path srcFile, Path dstFile, boolean overwrite) {
        if (Files.exists(dstFile, new LinkOption[0]) && !overwrite) {
            throw new JuRuntimeException("Destination file %s already exists", dstFile);
        }
        try {
            Files.createDirectories(dstFile.getParent(), new FileAttribute[0]);
            Files.copy(srcFile, dstFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't copy file %s to %s", (Throwable)ex, srcFile, dstFile);
        }
    }

    public static boolean deleteFiles(Path ... paths) {
        boolean oneDeleted = false;
        for (Path path : paths) {
            if (!IOUtil.deleteFile(path)) continue;
            oneDeleted = true;
        }
        return oneDeleted;
    }

    public static Path createFile(Path file, boolean overwrite) throws JuException {
        try {
            if (Files.exists(file, new LinkOption[0])) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    throw new JuException("Directory with file name exists: " + file);
                }
                if (!overwrite) {
                    throw new JuException("File exists: " + file);
                }
                Files.delete(file);
                Files.createFile(file, new FileAttribute[0]);
            } else {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.createFile(file, new FileAttribute[0]);
            }
        }
        catch (JuException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JuException("Couldn't create file " + file, ex);
        }
        return file;
    }

    public static boolean isSerializable(Object obj) {
        return IOUtil.isSerializableOrException(obj) == null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Exception isSerializableOrException(Object obj) {
        try (ObjectOutputStream s = new ObjectOutputStream(new ByteArrayOutputStream());){
            s.writeObject(obj);
            Exception exception = null;
            return exception;
        }
        catch (Exception ex) {
            return ex;
        }
    }

    public static List<Path> listFiles(Path parentDir) {
        return IOUtil.listFiles(parentDir, Predicates.ALWAYS_TRUE);
    }

    public static List<Path> listFiles(Path parentDir, final String ending) {
        return IOUtil.listFiles(parentDir, new Predicate<Path>(){

            @Override
            public boolean test(Path input) {
                return input.getFileName().toString().endsWith(ending);
            }
        });
    }

    public static List<Path> listFiles(Path parentDir, final Predicate<Path> predicate) {
        final ArrayList<Path> files = new ArrayList<Path>();
        try {
            Files.walkFileTree(parentDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (predicate.test(file)) {
                        files.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return files;
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't list file of directory %s", (Throwable)ex, parentDir);
        }
    }

    public static ExistsBuilder exists() {
        return new ExistsBuilder();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String loadTextFromUrl(URL url, String ... replacements) {
        Validate.notNull((Object)url, (String)"Cannot load text from null URL", (Object[])new Object[0]);
        try (BufferedReader reader = this.createReader(url);){
            int read;
            StringBuilder sb = new StringBuilder();
            char[] buff = new char[1024];
            while ((read = reader.read(buff)) > 0) {
                sb.append(buff, 0, read);
            }
            String string = JuStringUtils.replaceAll(sb.toString(), replacements);
            return string;
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't load text from URL " + url, ex);
        }
    }

    public BufferedReader createReader(URL url) {
        try {
            return new BufferedReader(new NewLineReader(new InputStreamReader(url.openStream(), this.charset), null, NewLineReader.LF));
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't create reader for URL " + url, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties loadPropertiesFromUrl(URL url) throws JuException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), this.charset));){
            Properties props = new Properties();
            props.load(reader);
            Properties properties = props;
            return properties;
        }
        catch (Exception ex) {
            throw new JuException("Couldn't load properties from URL: " + url, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Manifest loadManifestFromUrl(URL url) throws JuException {
        try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
            Manifest manifest = new Manifest(in);
            return manifest;
        }
        catch (Exception ex) {
            throw new JuException("Couldn't load manifest from URL: " + url, ex);
        }
    }

    public void writeTextToFile(String text, Path file, boolean overwrite) throws JuException {
        try {
            if (Files.exists(file, new LinkOption[0])) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    throw new JuException("Directory with file name exists: " + file);
                }
                if (!overwrite) {
                    throw new JuException("File exists: " + file);
                }
            }
            try (BufferedWriter w = Files.newBufferedWriter(file, Charset.forName(this.charset), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                w.write(text);
            }
        }
        catch (JuException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JuException("Couldn't write text to file: " + file, ex);
        }
    }

    public Writer openWriter(Path file, boolean append, boolean overwrite) throws JuException {
        if (append) {
            AssertUtil.assertFalse("When appending, overwrite must be set to false", overwrite);
        }
        try {
            StandardOpenOption openOption = StandardOpenOption.WRITE;
            if (Files.exists(file, new LinkOption[0]) && append) {
                openOption = StandardOpenOption.APPEND;
            } else {
                IOUtil.createFile(file, overwrite);
            }
            return Files.newBufferedWriter(file, Charset.forName(this.charset), openOption);
        }
        catch (JuException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JuException("Couldn't open Writer to: " + file, ex);
        }
    }

    public String toString() {
        return JuStringUtils.toString(this, "charset", this.charset);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Reader input) {
        IOUtil.closeQuietly((Closeable)input);
    }

    public static final class ExistsBuilder {
        private boolean noExceptions = true;

        private ExistsBuilder() {
        }

        public ExistsBuilder noExceptions(boolean noExceptions) {
            this.noExceptions = noExceptions;
            return this;
        }

        public boolean file(String path) {
            try {
                Path filePath = path.toLowerCase().startsWith("file:") ? JuUrl.toPath(new URL(path)) : Paths.get(path, new String[0]);
                return Files.isRegularFile(filePath, new LinkOption[0]);
            }
            catch (Exception ex) {
                return this.handleException(ex, false);
            }
        }

        public boolean file(Path path) {
            try {
                return Files.isRegularFile(path, new LinkOption[0]);
            }
            catch (Exception ex) {
                return this.handleException(ex, false);
            }
        }

        private <T> T handleException(Exception ex, T res) {
            if (this.noExceptions) {
                return res;
            }
            throw new JuRuntimeException("Couldn't check for existence", ex);
        }
    }
}

