/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.ManifestUtils;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ManifestUtilsTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void findsManifest_byAttribute() {
        String vendorId = ((ManifestUtils.ManifestFinder.ManifestWrapper)ManifestUtils.find().byAttribute("Implementation-Title", "slf4j-api").find().one()).getValue("Bundle-Vendor");
        Assert.assertEquals((Object)"SLF4J.ORG", (Object)vendorId);
    }

    @Test
    public void returnsNull_forMissingEntry() {
        String res = ((ManifestUtils.ManifestFinder.ManifestWrapper)ManifestUtils.find().byAttribute("Implementation-Title", "slf4j-api").find().one()).getValue("BliBla");
        Assert.assertNull((Object)res);
    }

    @Test
    public void findOne_throwsException_forMultipleResults() {
        this.exception.expect(JuRuntimeException.class);
        this.exception.expectMessage("More than 1 item available");
        ManifestUtils.find().byAttribute("Manifest-Version", "1\\.0").find().one();
    }

    @Test
    public void canFind_multipleManifests() {
        List manifests = ManifestUtils.find().byAttribute("Manifest-Version", "1\\.0").find().all();
        Assert.assertTrue((manifests.size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void canReadInfo_fromJarManifest() {
        String bundleName = ((ManifestUtils.ManifestFinder.ManifestWrapper)ManifestUtils.find().byJar("slf4j-log4j12.*").find().one()).getValue("Bundle-Name");
        Assert.assertEquals((Object)"slf4j-log4j12", (Object)bundleName);
    }

    @Test
    public void returnsNull_forMissingManifest() {
        String res = ((ManifestUtils.ManifestFinder.ManifestWrapper)ManifestUtils.find().byJar("someJar").find().oneOrNone()).getValue("Bundle-Name");
        Assert.assertNull((Object)res);
    }
}

