/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.xml;

import ch.inftec.ju.util.JuRuntimeException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XmlBuilder {
    private final XmlBuilder parentBuilder;
    private final Document document;
    private final Element element;
    private final Map<String, String> namespaces = new HashMap<String, String>();

    static XmlBuilder createRootBuilder(String rootElementName, String namespacePrefix, String namespaceUri) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            document.setXmlStandalone(true);
            Element rootElement = null;
            if (namespacePrefix != null) {
                rootElement = document.createElementNS(namespaceUri, rootElementName);
                rootElement.setPrefix(namespacePrefix);
            } else {
                rootElement = document.createElement(rootElementName);
            }
            document.appendChild(rootElement);
            XmlBuilder xb = new XmlBuilder(null, document, rootElement);
            if (namespacePrefix != null) {
                xb.addNamespace(namespacePrefix, namespaceUri);
            }
            return xb;
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't initialize XML Document");
        }
    }

    private XmlBuilder(XmlBuilder parentBuilder, Document document, Element element) throws JuRuntimeException {
        this.parentBuilder = parentBuilder;
        this.document = document;
        this.element = element;
    }

    public XmlBuilder addNamespace(String prefix, String uri) {
        if (this.namespaces.containsKey(prefix)) {
            throw new IllegalArgumentException(String.format("Namespace with prefix %s has already been added", new Object[0]));
        }
        this.namespaces.put(prefix, uri);
        return this;
    }

    public XmlBuilder setAttribute(String name, String value) {
        this.element.setAttribute(name, value);
        return this;
    }

    public XmlBuilder addText(String text) {
        Text textNode = this.document.createTextNode(text);
        this.element.appendChild(textNode);
        return this;
    }

    public XmlBuilder addChild(String elementName) {
        Element child = this.document.createElement(elementName);
        this.element.appendChild(child);
        return new XmlBuilder(this, this.document, child);
    }

    public XmlBuilder addChild(String elementName, String namespacePrefix) {
        Element child = this.document.createElementNS(this.getNamespaceUri(namespacePrefix), elementName);
        child.setPrefix(namespacePrefix);
        this.element.appendChild(child);
        return new XmlBuilder(this, this.document, child);
    }

    private String getNamespaceUri(String prefix) {
        if (this.namespaces.containsKey(prefix)) {
            return this.namespaces.get(prefix);
        }
        if (this.parentBuilder != null) {
            return this.parentBuilder.getNamespaceUri(prefix);
        }
        throw new IllegalArgumentException("Unknown namespace: " + prefix);
    }

    public XmlBuilder endChild() {
        if (this.parentBuilder == null) {
            throw new IllegalStateException("Cannot call endChild on root builder");
        }
        return this.parentBuilder;
    }

    public Document getDocument() {
        return this.document;
    }
}

