/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.helper;

import ch.inftec.ju.util.ConversionUtils;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.helper.ValueConverter;
import java.util.Date;

public class ValueConverterFactory {
    public static ValueConverter createNewValueConverter(Object obj) {
        return new ValueConverterImpl(obj);
    }

    private static class ValueConverterImpl
    implements ValueConverter {
        private final Object obj;

        private ValueConverterImpl(Object obj) {
            this.obj = obj;
        }

        @Override
        public Object get() {
            return this.obj;
        }

        @Override
        public <T> T get(Class<T> clazz) {
            return this.convert(clazz);
        }

        private <T> T convert(Class<T> clazz) {
            Object obj = this.get();
            if (obj == null) {
                return null;
            }
            if (obj.getClass() == clazz) {
                return (T)obj;
            }
            if (clazz == Integer.class) {
                Long l = ConversionUtils.toLong(obj);
                return (T)new Integer(l.intValue());
            }
            if (clazz == Long.class) {
                Long l = ConversionUtils.toLong(obj);
                return (T)l;
            }
            if (clazz == Boolean.class) {
                return (T)new Boolean(obj.toString());
            }
            if (clazz == String.class) {
                return (T)obj.toString();
            }
            if (clazz == Date.class) {
                return (T)JuStringUtils.parseIso8601Date(obj.toString());
            }
            throw new JuRuntimeException("Conversion not supported: " + clazz);
        }
    }
}

