/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.general;

import ch.inftec.ju.util.context.GenericContext;
import ch.inftec.ju.util.context.GenericContextUtils;
import ch.inftec.ju.util.event.EventNotifier;
import ch.inftec.ju.util.event.JuEventObject;
import ch.inftec.ju.util.event.JuEventUtils;
import ch.inftec.ju.util.event.UpdateListener;
import ch.inftec.ju.util.general.Descriptor;

public final class DescriptorUtils {
    private DescriptorUtils() {
        throw new AssertionError((Object)"use only statically");
    }

    public static Descriptor newInstance(String name) {
        return new DescriptorImpl(name, name);
    }

    public static Descriptor newInstance(String name, String description) {
        return new DescriptorImpl(name, description);
    }

    public static DescriptorBuilder builder(String name) {
        return new DescriptorBuilder(name, name);
    }

    public static final class DescriptorBuilder {
        private DescriptorImpl descriptorImpl;
        GenericContextUtils.GenericContextBuilder contextBuilder = GenericContextUtils.builder();

        private DescriptorBuilder(String name, String description) {
            this.descriptorImpl = new DescriptorImpl(name, description);
        }

        public DescriptorBuilder description(String description) {
            this.descriptorImpl.description = description;
            return this;
        }

        public DescriptorBuilder evaluator(DescriptionEvaluator descriptionEvaluator) {
            this.descriptorImpl.setDescriptionEvaluator(descriptionEvaluator);
            return this;
        }

        public <T> DescriptorBuilder setObject(Class<T> clazz, T obj) {
            this.contextBuilder.setObject(clazz, obj);
            return this;
        }

        public Descriptor getDescriptor() {
            this.descriptorImpl.setGenericContext(this.contextBuilder.build());
            return this.descriptorImpl;
        }
    }

    private static final class DescriptorImpl
    implements Descriptor,
    UpdateListener<DescriptionEvaluator> {
        final String name;
        String description;
        private DescriptionEvaluator descriptionEvaluator;
        GenericContext context;
        private JuEventUtils.UpdateEventNotifier<Descriptor> updateNotifier = JuEventUtils.newUpdateEventNotifier();

        private DescriptorImpl(String name, String description) {
            this.name = name;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            if (this.descriptionEvaluator != null && this.descriptionEvaluator.getDescription() != null) {
                return this.descriptionEvaluator.getDescription();
            }
            return this.description;
        }

        void setDescriptionEvaluator(DescriptionEvaluator descriptionEvaluator) {
            if (this.descriptionEvaluator != null) {
                this.descriptionEvaluator.getUpdateNotifier().removeListener(this);
            }
            this.descriptionEvaluator = descriptionEvaluator;
            if (this.descriptionEvaluator != null) {
                this.descriptionEvaluator.getUpdateNotifier().addListener(this);
            }
        }

        void setGenericContext(GenericContext context) {
            this.context = context;
        }

        @Override
        public <T> T getObject(Class<T> clazz) {
            if (this.descriptionEvaluator != null && this.descriptionEvaluator.getObject(clazz) != null) {
                return this.descriptionEvaluator.getObject(clazz);
            }
            return GenericContextUtils.asX(this.context).getObject(clazz);
        }

        @Override
        public EventNotifier<UpdateListener<Descriptor>> getUpdateNotifier() {
            return this.updateNotifier;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public void updated(JuEventObject<DescriptionEvaluator> event) {
            this.updateNotifier.fireUpdateEvent(this);
        }
    }

    public static abstract class AbstractDescriptionEvaluator
    implements DescriptionEvaluator {
        private final JuEventUtils.UpdateEventNotifier<DescriptionEvaluator> updateNotifier = JuEventUtils.newUpdateEventNotifier();
        private String description;

        @Override
        public final String getDescription() {
            if (this.description == null) {
                this.description = this.evaluateDescription();
            }
            return this.description;
        }

        protected String evaluateDescription() {
            return null;
        }

        @Override
        public final <T> T getObject(Class<T> clazz) {
            return this.evaluateObject(clazz);
        }

        protected <T> T evaluateObject(Class<T> clazz) {
            return null;
        }

        protected final void updateDescription() {
            this.description = null;
            this.updateNotifier.fireUpdateEvent(this);
        }

        @Override
        public EventNotifier<UpdateListener<DescriptionEvaluator>> getUpdateNotifier() {
            return this.updateNotifier;
        }
    }

    public static interface DescriptionEvaluator {
        public String getDescription();

        public <T> T getObject(Class<T> var1);

        public EventNotifier<UpdateListener<DescriptionEvaluator>> getUpdateNotifier();
    }
}

