/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.collection;

import ch.inftec.ju.util.collection.Cache;
import ch.inftec.ju.util.function.Function;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

class SimpleCache<K, V>
implements Cache<K, V> {
    private final int maxSize;
    private final Function<K, V> unknownValueGetter;
    private final Map<K, V> items = new LinkedHashMap();

    SimpleCache(int maxSize, Function<K, V> unknownValueGetter) {
        Validate.isTrue((maxSize > 0 ? 1 : 0) != 0, (String)"maxSize must be greater than 0, but was %d", (long)maxSize);
        Validate.notNull(unknownValueGetter, (String)"unknownValueGetter must be specified", (Object[])new Object[0]);
        this.maxSize = maxSize;
        this.unknownValueGetter = unknownValueGetter;
    }

    @Override
    public synchronized V get(K key) {
        if (!this.items.containsKey(key)) {
            V value = this.unknownValueGetter.apply(key);
            this.items.put(key, value);
        } else {
            V value = this.items.get(key);
            this.items.remove(key);
            this.items.put(key, value);
        }
        this.truncateCache();
        return this.items.get(key);
    }

    @Override
    public synchronized void put(K key, V value) {
        this.items.put(key, value);
        this.truncateCache();
    }

    @Override
    public synchronized long size() {
        return this.items.size();
    }

    private synchronized void truncateCache() {
        while (this.items.size() > this.maxSize) {
            K oldestKey = this.items.keySet().iterator().next();
            this.items.remove(oldestKey);
        }
    }
}

