/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.io.LineIterator;
import ch.inftec.ju.util.io.NewLineReader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class XString {
    private ArrayList<Line> lines = new ArrayList();
    private String s;
    private String lineBreak = "\n";
    private String indentString = "  ";
    private String placeHolderDelimiter = "%";
    private String nullReplacementValue = "";
    private int indentLevel = 0;
    private int lastIndentIncrease = 0;

    public XString() {
    }

    public XString(String s) {
        this.addLine(s);
    }

    public XString(String format, Object ... args) {
        this.addFormatted(format, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XString parseLines(String s) {
        if (s == null) return new XString("");
        if (s.isEmpty()) {
            return new XString("");
        }
        XString xs = new XString();
        try (NewLineReader r = new NewLineReader(new StringReader(s));){
            LineIterator i = r.iterateLines();
            while (i.hasNext()) {
                xs.addLine(i.nextLine());
            }
            if (r.getInputNewLine() != null) {
                xs.setLineBreak(r.getInputNewLine());
            }
            XString xString = xs;
            return xString;
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't parse String", ex);
        }
    }

    public XString newEmptyInstance() {
        XString xs = new XString();
        xs.setLineBreak(this.getLineBreak());
        xs.setIndentString(this.getIndentString());
        xs.setPlaceHolderDelimiter(this.getPlaceHolderDelimiter());
        xs.setNullReplacementValue(this.getNullReplacementValue());
        return xs;
    }

    public XString newInstance(String text) {
        XString xs = this.newEmptyInstance();
        xs.addText(text);
        return xs;
    }

    public XString newClonedInstance() {
        XString xs = this.newEmptyInstance();
        xs.s = this.s;
        xs.lines = new ArrayList();
        for (int i = 0; i < this.lines.size(); ++i) {
            Line l = this.lines.get(i);
            xs.lines.add(new Line(l.getString(), l.getIndentation()));
        }
        return xs;
    }

    public void addLine(String line) {
        this.lines.add(new Line(line == null ? "" : line, this.indentLevel));
        this.flagChanged();
    }

    public void addLineFormatted(String format, Object ... args) {
        this.addLine(String.format(format, args));
    }

    public void addLine(Object ... objs) {
        this.addLine(null);
        for (Object obj : objs) {
            this.addText(obj);
        }
    }

    public void newLine() {
        this.addLine(null);
    }

    public String getLine(int index) {
        if (this.lines.size() <= index) {
            throw new IndexOutOfBoundsException(String.format("Line has only %d lines, cannot access line %d", this.lines.size(), index));
        }
        return this.lines.get(index).toString();
    }

    protected Line getLastLine() {
        if (this.lines.size() == 0) {
            this.addLine(null);
        }
        return this.lines.get(this.lines.size() - 1);
    }

    public void addText(String text) {
        this.getLastLine().addText(text);
        this.flagChanged();
    }

    public void addText(Object ... objs) {
        for (Object obj : objs) {
            this.addText(obj == null ? "" : obj.toString());
        }
    }

    public void addFormatted(String format, Object ... args) {
        this.addText(String.format(format, args));
    }

    public void assertText(String ... texts) {
        if (ArrayUtils.isEmpty((Object[])texts)) {
            return;
        }
        Line l = this.getLastLine();
        for (String text : texts) {
            if (!l.getString().endsWith(text)) continue;
            return;
        }
        this.addText(texts[texts.length - 1]);
    }

    public void assertEmptyOrText(String text) {
        Line l = this.getLastLine();
        if (l.getString().length() > 0) {
            this.assertText(text);
        }
    }

    public void addItems(String delimiter, Object ... items) {
        boolean firstItem = true;
        for (Object item : items) {
            if (firstItem) {
                firstItem = false;
            } else {
                this.addText(delimiter);
            }
            this.addText(this.toString(item));
        }
    }

    public void increaseIndent() {
        this.increaseIndent(1);
    }

    public void increaseIndent(int levels) {
        this.indentLevel += levels;
        this.lastIndentIncrease = levels;
    }

    public void decreaseIndent() {
        this.indentLevel -= this.lastIndentIncrease;
    }

    public void decreaseIndent(int levels) {
        this.indentLevel -= levels;
        if (this.indentLevel < 0) {
            throw new IllegalStateException("Indent level may not fall below 0");
        }
    }

    public String getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(String lineBreak) {
        this.lineBreak = lineBreak;
        this.flagChanged();
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
        this.flagChanged();
    }

    public String getPlaceHolderDelimiter() {
        return this.placeHolderDelimiter;
    }

    public void setPlaceHolderDelimiter(String s) {
        this.placeHolderDelimiter = s;
    }

    public String getNullReplacementValue() {
        return this.nullReplacementValue;
    }

    public void setNullReplacementValue(String nullReplacementValue) {
        this.nullReplacementValue = nullReplacementValue;
    }

    public String[] getPlaceHolders() {
        ArrayList<String> placeHolders = new ArrayList<String>();
        String s = this.toString();
        int plLength = this.getPlaceHolderDelimiter().length();
        int startIndex = s.indexOf(this.getPlaceHolderDelimiter());
        while (startIndex >= 0 && startIndex < s.length() - plLength) {
            int endIndex = s.indexOf(this.getPlaceHolderDelimiter(), startIndex + plLength);
            if (endIndex > startIndex + plLength) {
                String placeHolder = s.substring(startIndex + plLength, endIndex);
                if (JuStringUtils.containsWhitespace(placeHolder)) {
                    startIndex = endIndex;
                    continue;
                }
                if (!placeHolders.contains(placeHolder)) {
                    placeHolders.add(placeHolder);
                }
                startIndex = s.indexOf(this.getPlaceHolderDelimiter(), endIndex + plLength);
                continue;
            }
            if (endIndex <= 0) break;
            startIndex = endIndex + plLength;
        }
        return placeHolders.toArray(new String[placeHolders.size()]);
    }

    public int setPlaceholder(String placeHolder, String value) {
        if (placeHolder == null || placeHolder.length() < 1 || JuStringUtils.containsWhitespace(placeHolder)) {
            throw new IllegalArgumentException("Placeholder must contain at least one character and must not contain whitespace: " + placeHolder);
        }
        String replacementString = this.getPlaceHolderDelimiter() + placeHolder + this.getPlaceHolderDelimiter();
        int cnt = 0;
        for (Line line : this.lines) {
            String s = line.getString();
            int lCnt = JuStringUtils.occurrancies(s, replacementString);
            if (lCnt <= 0) continue;
            cnt += lCnt;
            line.setString(s.replaceAll(replacementString, this.toString(value)));
            this.flagChanged();
        }
        return cnt;
    }

    private void flagChanged() {
        this.s = null;
    }

    public String toString() {
        if (this.s == null) {
            StringBuilder sb = new StringBuilder();
            boolean firstLine = true;
            for (Line line : this.lines) {
                if (!firstLine) {
                    sb.append(this.lineBreak);
                }
                sb.append(JuStringUtils.times(this.indentString, line.getIndentation()));
                sb.append(line.getString());
                firstLine = false;
            }
            this.s = sb.toString();
        }
        return this.s;
    }

    public int getLineCount() {
        return Math.max(1, this.lines.size());
    }

    public boolean isEmpty() {
        return this.getLineCount() == 1 && this.toString().isEmpty();
    }

    public int getLongestLineLength() {
        int maxSize = 0;
        for (Line l : this.lines) {
            maxSize = Math.max(maxSize, l.getString().length());
        }
        return maxSize;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        String s;
        if (obj == null) {
            return false;
        }
        if (obj instanceof XString) {
            s = obj.toString();
        } else if (obj instanceof String) {
            s = (String)obj;
        } else {
            return false;
        }
        return ObjectUtils.equals((Object)this.toString(), (Object)s);
    }

    private String toString(Object obj) {
        return obj == null ? this.getNullReplacementValue() : obj.toString();
    }

    private class Line {
        StringBuilder sb;
        String s;
        private int indentation;

        public Line(String s, int indentation) {
            this.s = s;
            this.indentation = indentation;
        }

        public String getString() {
            return this.s == null ? this.sb.toString() : this.s;
        }

        public void setString(String s) {
            this.s = s;
            this.sb = null;
        }

        public void addText(String s) {
            if (this.sb == null) {
                this.sb = new StringBuilder(this.s);
                this.s = null;
            }
            this.sb.append(s == null ? "" : s);
        }

        public int getIndentation() {
            return this.indentation;
        }

        public String toString() {
            return this.getString();
        }
    }
}

