/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import java.util.ArrayList;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexUtil {
    public static final String WHITESPACE = "\\s";
    public static final String DIGIT = "\\d";
    public static final String WORD = "\\w";
    private transient Pattern pattern;
    private final String patternString;
    private boolean isCaseInsensitive = false;

    public RegexUtil(String pattern) {
        this.patternString = pattern;
    }

    public boolean isCaseInsensitive() {
        return this.isCaseInsensitive;
    }

    public void setCaseInsensitive(boolean isCaseInsensitive) {
        if (this.isCaseInsensitive != isCaseInsensitive) {
            this.isCaseInsensitive = isCaseInsensitive;
            this.invalidatePattern();
        }
    }

    private void invalidatePattern() {
        this.pattern = null;
    }

    private Pattern getPattern() {
        if (this.pattern == null) {
            int flags = this.isCaseInsensitive ? 2 : 0;
            this.pattern = Pattern.compile(this.patternString, flags);
        }
        return this.pattern;
    }

    public boolean matches(String s) {
        return s != null && this.getPattern().matcher(s).matches();
    }

    public boolean containsMatch(String s) {
        return s != null && this.getPattern().matcher(s).find();
    }

    public Match[] getMatches(String s) {
        if (s == null) {
            return new Match[0];
        }
        Matcher matcher = this.getPattern().matcher(s);
        int index = 0;
        ArrayList<Match> matches = new ArrayList<Match>();
        Match firstEmptyMatch = null;
        while (index < s.length() && matcher.find(index)) {
            MatchResult result = matcher.toMatchResult();
            if (index == matcher.end()) {
                if (firstEmptyMatch == null) {
                    firstEmptyMatch = new Match(result);
                }
                index = matcher.end() + 1;
                continue;
            }
            matches.add(new Match(matcher.toMatchResult()));
            index = matcher.end();
        }
        if (matches.size() == 0 && firstEmptyMatch != null) {
            matches.add(firstEmptyMatch);
        }
        return matches.toArray(new Match[0]);
    }

    public int getFirstMatchIndex(String s) {
        Match[] matches = this.getMatches(s);
        if (matches.length == 0) {
            return -1;
        }
        return matches[0].matchResult.start();
    }

    public String[] getStringMatches(String s) {
        Match[] matches = this.getMatches(s);
        String[] stringMatches = new String[matches.length];
        for (int i = 0; i < stringMatches.length; ++i) {
            stringMatches[i] = matches[i].getFullMatch();
        }
        return stringMatches;
    }

    public String toString() {
        return this.patternString;
    }

    public class Match {
        private MatchResult matchResult;

        private Match(MatchResult matchResult) {
            this.matchResult = matchResult;
        }

        public String getFullMatch() {
            return this.matchResult.group();
        }

        public String[] getGroups() {
            ArrayList<String> groups = new ArrayList<String>();
            for (int i = 0; i < this.matchResult.groupCount(); ++i) {
                groups.add(this.matchResult.group(i + 1));
            }
            return groups.toArray(new String[0]);
        }
    }
}

