/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.security.JuSecurityUtils;
import ch.inftec.ju.security.JuTextEncryptor;
import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.CsvTableLookup;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.InterpolatingPropertyChain;
import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.JuException;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.PropertyChain;
import ch.inftec.ju.util.PropertyEvaluator;
import ch.inftec.ju.util.XString;
import java.io.BufferedReader;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyChainBuilder {
    private Logger logger = LoggerFactory.getLogger(PropertyChainBuilder.class);
    private final List<Path> resourceFolders = new ArrayList<Path>();
    private final List<PropertyEvaluator> evaluators = new ArrayList<PropertyEvaluator>();
    private InterpolationBuilder interpolationBuilder = new InterpolationBuilder();
    private final Set<String> hiddenValueKeys = new HashSet<String>();
    private static final String ENCRYPTED_VALUE_LOGGING_STRING = "***";
    private JuTextEncryptor decryptor;
    private boolean defaultThrowExceptionIfUndefined = false;

    public PropertyChainBuilder hideValueForKey(String key) {
        this.hiddenValueKeys.add(key);
        return this;
    }

    public PropertyChainBuilder addSystemPropertyEvaluator() {
        return this.addPropertyEvaluator(new SystemPropertyEvaluator());
    }

    public PropertyChainBuilder addResourceFolder(Path resourceFolder) {
        if (JuUrl.path().isExistingDirectory(resourceFolder)) {
            this.resourceFolders.add(resourceFolder);
        } else {
            this.logger.warn("Not an existing directory. Folder will be ignored: {}", (Object)resourceFolder.toAbsolutePath());
        }
        return this;
    }

    public PropertyChainBuilder addResourcePropertyEvaluator(URL resourceUrl) {
        try {
            return this.addPropertyEvaluator(new PropertiesPropertyEvaluator(resourceUrl));
        }
        catch (JuException ex) {
            throw new JuRuntimeException("Couldn't load properties from url " + resourceUrl, ex);
        }
    }

    public PropertyChainBuilder addResourcePropertyEvaluator(String resourceName, boolean ignoreMissingResource) {
        try {
            URL resourceUrl = JuUrl.resource(resourceName);
            return this.addPropertyEvaluator(new PropertiesPropertyEvaluator(resourceUrl));
        }
        catch (JuException ex) {
            if (ignoreMissingResource) {
                this.logger.debug(String.format("Ignoring missing resource %s (Exception: %s)", resourceName, ex.getMessage()));
                return this;
            }
            throw new JuRuntimeException("Couldn't load properties from resource " + resourceName, ex);
        }
    }

    public PropertyChainBuilder addPropertiesPropertyEvaluator(Properties props) {
        return this.addPropertyEvaluator(new PropertiesPropertyEvaluator(props));
    }

    public PropertyChainBuilder addListPropertyEvaluator(String ... keyValuePairs) {
        Properties props = new Properties();
        int i = 0;
        while (i + 1 < keyValuePairs.length) {
            props.put(keyValuePairs[i], keyValuePairs[i + 1]);
            i += 2;
        }
        return this.addPropertiesPropertyEvaluator(props);
    }

    public PropertyChainBuilder addPropertyChainPropertyEvaluator(PropertyChain chain) {
        return this.addPropertyEvaluator(new PropertyChainPropertyEvaluator(chain));
    }

    public PropertyChainBuilder addCsvPropertyEvaluator(URL resourceUrl, String profileName, String defaultColumnName) {
        CsvPropertyEvaluator csvEvaluator = new CsvPropertyEvaluator(resourceUrl, profileName, defaultColumnName);
        return this.addPropertyEvaluator(csvEvaluator);
    }

    public PropertyChainBuilder addPropertyEvaluator(PropertyEvaluator evaluator) {
        this.evaluators.add(evaluator);
        return this;
    }

    public PropertyChainBuilder setDefaultThrowExceptionIfUndefined(boolean defaultThrowExceptionIfUndefined) {
        this.defaultThrowExceptionIfUndefined = defaultThrowExceptionIfUndefined;
        return this;
    }

    public PropertyChainBuilder setDecryptor(JuTextEncryptor decryptor) {
        this.decryptor = decryptor;
        return this;
    }

    public PropertyChainBuilder setDecryptorByResource(String passwordResourceName, boolean strongEncryption) {
        URL resourceUrl = this.getFileResource(passwordResourceName, false);
        this.setDecryptor(JuSecurityUtils.buildEncryptor().passwordByUrl(resourceUrl).strong(strongEncryption).createTextEncryptor());
        return this;
    }

    public InterpolationBuilder interpolation() {
        return this.interpolationBuilder;
    }

    public InterpolatingPropertyChain peekChain() {
        return new PropertyChainImpl(this, false);
    }

    public ChainFilesResolver addEvaluatorsByChainFiles() {
        return new ChainFilesResolver();
    }

    public InterpolatingPropertyChain getPropertyChain() {
        return new PropertyChainImpl(this, this.defaultThrowExceptionIfUndefined);
    }

    private URL getFileResource(String resourceName, boolean optional) {
        for (Path p : this.resourceFolders) {
            Path resourcePath = p.resolve(resourceName);
            if (!JuUrl.path().isExistingFile(resourcePath)) continue;
            return JuUrl.toUrl(resourcePath);
        }
        return JuUrl.resource().single().exceptionIfNone(!optional).get(resourceName, false);
    }

    private static class PropertyInfoImpl
    implements PropertyChain.PropertyInfo {
        private final String key;
        private final Object rawValue;
        private final String evaluatorInfo;
        private Object value;
        private String displayValue;
        private boolean isSensitive;

        private PropertyInfoImpl(String key, Object rawValue, String evaluatorInfo) {
            this.key = key;
            this.rawValue = rawValue;
            this.evaluatorInfo = evaluatorInfo;
            this.value = rawValue;
            this.displayValue = rawValue == null ? null : rawValue.toString();
        }

        public void setDisplayValue(String displayValue) {
            this.displayValue = displayValue;
        }

        public void setSensitive(boolean isSensitive) {
            this.isSensitive = isSensitive;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        private void setValue(Object val) {
            if (ObjectUtils.equals((Object)this.value, (Object)this.displayValue)) {
                this.displayValue = val == null ? null : val.toString();
            }
            this.value = val;
        }

        @Override
        public String getValue() {
            return this.value == null ? null : this.value.toString();
        }

        @Override
        public String getDisplayValue() {
            return this.displayValue == null ? null : this.displayValue;
        }

        @Override
        public String getRawValue() {
            return this.rawValue == null ? null : this.rawValue.toString();
        }

        @Override
        public boolean isSensitive() {
            return this.isSensitive;
        }

        @Override
        public String getEvaluatorInfo() {
            return this.evaluatorInfo;
        }

        public String toString() {
            return String.format("%s=%s [using %s]", this.getKey(), this.getDisplayValue(), this.getEvaluatorInfo());
        }
    }

    private static class PropertyChainPropertyEvaluator
    implements PropertyEvaluator {
        private final PropertyChain nestedChain;

        public PropertyChainPropertyEvaluator(PropertyChain chain) {
            this.nestedChain = chain;
        }

        @Override
        public Object get(String key) {
            return this.nestedChain.get(key, Object.class);
        }

        @Override
        public Set<String> listKeys() {
            return this.nestedChain.listKeys();
        }

        public String toString() {
            return JuStringUtils.toString(this, "nestedChain", this.nestedChain);
        }
    }

    private static class CsvPropertyEvaluator
    implements PropertyEvaluator {
        private final URL resourceUrl;
        private final String profile;
        private final CsvTableLookup csvTable;

        public CsvPropertyEvaluator(URL resourceUrl, String profile, String defaultColumn) {
            this.resourceUrl = resourceUrl;
            this.profile = profile;
            this.csvTable = CsvTableLookup.build().from(resourceUrl).defaultColumn(defaultColumn).create();
        }

        @Override
        public Object get(String key) {
            return this.csvTable.get(key, this.profile);
        }

        public String toString() {
            return JuStringUtils.toString(this, "url", this.resourceUrl, "profile", this.profile);
        }

        @Override
        public Set<String> listKeys() {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            keys.addAll(this.csvTable.getKeys());
            return keys;
        }
    }

    private static class PropertiesPropertyEvaluator
    implements PropertyEvaluator {
        private final URL propertiesUrl;
        private final Properties props;

        public PropertiesPropertyEvaluator(Properties props) {
            this.propertiesUrl = null;
            this.props = props;
        }

        public PropertiesPropertyEvaluator(URL propertiesUrl) throws JuException {
            this.propertiesUrl = propertiesUrl;
            this.props = new IOUtil().loadPropertiesFromUrl(propertiesUrl);
        }

        @Override
        public Object get(String key) {
            return this.props == null ? null : this.props.get(key);
        }

        public String toString() {
            if (this.propertiesUrl != null) {
                return JuStringUtils.toString(this, "url", this.propertiesUrl);
            }
            return JuStringUtils.toString(this, new Object[0]);
        }

        @Override
        public Set<String> listKeys() {
            return JuCollectionUtils.getKeyStrings(this.props);
        }
    }

    private static class SystemPropertyEvaluator
    implements PropertyEvaluator {
        private SystemPropertyEvaluator() {
        }

        @Override
        public Object get(String key) {
            return System.getProperty(key);
        }

        public String toString() {
            return JuStringUtils.toString(this, new Object[0]);
        }

        @Override
        public Set<String> listKeys() {
            return JuCollectionUtils.getKeyStrings(System.getProperties());
        }
    }

    private static class PropertyChainImpl
    implements InterpolatingPropertyChain {
        private Logger logger = LoggerFactory.getLogger(PropertyChainImpl.class);
        private final List<PropertyEvaluator> evaluators;
        private final JuTextEncryptor decryptor;
        private final boolean defaultThrowExceptionIfUndefined;
        private final Interpolator interpolator;
        private final Set<String> hiddenValueKeys;

        private PropertyChainImpl(PropertyChainBuilder builder, boolean defaultThrowExceptionIfUndefined) {
            this.defaultThrowExceptionIfUndefined = defaultThrowExceptionIfUndefined;
            this.evaluators = new ArrayList<PropertyEvaluator>(builder.evaluators);
            this.decryptor = builder.decryptor;
            this.hiddenValueKeys = new HashSet<String>(builder.hiddenValueKeys);
            if (builder.interpolationBuilder.enabled) {
                this.interpolator = new RegexBasedInterpolator();
                if (builder.interpolationBuilder.envVariableInterpolation) {
                    try {
                        this.interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
                    }
                    catch (Exception ex) {
                        throw new JuRuntimeException("Couldn't create EnvarBasedValueSource", ex);
                    }
                }
                this.interpolator.addValueSource((ValueSource)new ChainValueSource());
            } else {
                this.interpolator = null;
            }
        }

        @Override
        public String get(String key) {
            return this.get(key, this.defaultThrowExceptionIfUndefined);
        }

        @Override
        public String get(String key, boolean throwExceptionIfNotDefined) {
            Object obj = this.getObject(key, null, throwExceptionIfNotDefined);
            return obj == null ? null : obj.toString();
        }

        @Override
        public String get(String key, String defaultValue) {
            String val = this.get(key, false);
            return val != null ? val : defaultValue;
        }

        @Override
        public <T> T get(String key, Class<T> clazz) {
            String val = this.get(key);
            return this.convert(val, clazz);
        }

        @Override
        public <T> T get(String key, Class<T> clazz, boolean throwExceptionIfNotDefined) {
            String val = this.get(key, throwExceptionIfNotDefined);
            return this.convert(val, clazz);
        }

        @Override
        public <T> T get(String key, Class<T> clazz, String defaultValue) {
            String val = this.get(key, defaultValue);
            return this.convert(val, clazz);
        }

        private <T> T convert(String val, Class<T> clazz) {
            if (StringUtils.isEmpty((CharSequence)val)) {
                return null;
            }
            if (clazz == Integer.class) {
                return (T)new Integer(val);
            }
            if (clazz == Boolean.class) {
                return (T)new Boolean(val);
            }
            if (clazz == Object.class) {
                return (T)val;
            }
            throw new JuRuntimeException("Conversion not supported: " + clazz);
        }

        private Object getObject(String key, Object defaultValue, boolean throwExceptionIfNotDefined) {
            PropertyInfoImpl pi = this.evaluteAndInterpolate(key);
            if (pi == null || pi.getValue() == null) {
                if (throwExceptionIfNotDefined) {
                    throw new JuRuntimeException("Property undefined: " + key);
                }
                return defaultValue;
            }
            return pi.getValue();
        }

        private PropertyInfoImpl evaluteAndInterpolate(String key) {
            PropertyInfoImpl pi = this.evaluate(key);
            if (this.interpolator != null && pi != null && pi.rawValue instanceof String) {
                try {
                    String interpolatedValue = this.interpolator.interpolate(pi.getValue());
                    pi.setValue(interpolatedValue);
                    return pi;
                }
                catch (InterpolationException ex) {
                    this.logger.warn("Couldn't interpolate " + pi.getValue(), (Throwable)ex);
                    return pi;
                }
            }
            return pi;
        }

        private PropertyInfoImpl evaluate(String key) {
            for (PropertyEvaluator evaluator : this.evaluators) {
                Object val = evaluator.get(key);
                if (val == null) continue;
                String stringVal = val.toString();
                PropertyInfoImpl pi = new PropertyInfoImpl(key, val, evaluator.toString());
                if (this.hiddenValueKeys.contains(key)) {
                    pi.setDisplayValue(PropertyChainBuilder.ENCRYPTED_VALUE_LOGGING_STRING);
                    pi.setSensitive(true);
                }
                if (JuSecurityUtils.isEncryptedByTag(stringVal)) {
                    if (this.decryptor != null) {
                        pi.setValue(JuSecurityUtils.decryptTaggedValueIfNecessary(stringVal, this.decryptor));
                        pi.setDisplayValue(PropertyChainBuilder.ENCRYPTED_VALUE_LOGGING_STRING);
                        pi.setSensitive(true);
                    } else {
                        this.logger.warn("Value seems to be encrypted, but no decrypted was set on the PropertyChain");
                    }
                }
                this.logger.debug("Evaluated property: {}", (Object)pi);
                return pi;
            }
            return null;
        }

        @Override
        public Set<String> listKeys() {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (PropertyEvaluator evaluator : this.evaluators) {
                keys.addAll(evaluator.listKeys());
            }
            return keys;
        }

        @Override
        public PropertyChain.PropertyInfo getInfo(String key) {
            return this.evaluteAndInterpolate(key);
        }

        @Override
        public String interpolate(String expression) {
            if (this.interpolator != null) {
                try {
                    return this.interpolator.interpolate(expression);
                }
                catch (Exception ex) {
                    this.logger.warn("Couldn't interpolate expression: " + expression, (Throwable)ex);
                }
            }
            return expression;
        }

        private class ChainValueSource
        extends AbstractValueSource {
            public ChainValueSource() {
                super(false);
            }

            public Object getValue(String expression) {
                PropertyInfoImpl pi = PropertyChainImpl.this.evaluate(expression);
                return pi != null ? pi.getValue() : null;
            }
        }
    }

    public final class InterpolationBuilder {
        private boolean enabled = true;
        private boolean envVariableInterpolation = true;

        public InterpolationBuilder enable(boolean enableInterpolation) {
            this.enabled = enableInterpolation;
            return this;
        }

        public PropertyChainBuilder done() {
            return PropertyChainBuilder.this;
        }
    }

    public final class ChainFilesResolver {
        private List<URL> propFiles = new ArrayList<URL>();

        public ChainFilesResolver name(String resourceName) {
            ArrayList<URL> files = new ArrayList<URL>();
            for (Path resourceFolder : PropertyChainBuilder.this.resourceFolders) {
                Path fsResource = resourceFolder.resolve(resourceName);
                if (!JuUrl.path().isExistingFile(fsResource)) continue;
                files.add(JuUrl.toUrl(fsResource));
            }
            files.addAll(JuUrl.resource().getAll(resourceName, false));
            this.propFiles.addAll(files);
            return this;
        }

        public PropertyChainBuilder resolve() {
            PropertyChainBuilder.this.logger.debug("Resolving PropertyChain by chain files");
            XString duplicatePrios = new XString();
            TreeMap<Integer, String[]> props = new TreeMap<Integer, String[]>();
            for (URL propFile : this.propFiles) {
                PropertyChainBuilder.this.logger.debug("Processing property file: " + propFile);
                XString filteredContents = new XString("Filtered contents: ");
                filteredContents.increaseIndent();
                try (BufferedReader r = new IOUtil().createReader(propFile);){
                    String line = r.readLine();
                    while (line != null) {
                        String[] lineParts = JuStringUtils.split(line, ",", true);
                        if (lineParts.length > 0 && !lineParts[0].startsWith("#")) {
                            AssertUtil.assertTrue("Invalid line: " + line, lineParts.length > 1);
                            filteredContents.addLine(line);
                            int priorization = Integer.parseInt(lineParts[0]);
                            if (props.containsKey(priorization)) {
                                duplicatePrios.addLineFormatted("Duplicate priorization in %s: %d", propFile, priorization);
                            }
                            props.put(priorization, Arrays.copyOfRange(lineParts, 1, lineParts.length));
                        }
                        line = r.readLine();
                    }
                }
                catch (Exception ex) {
                    throw new JuRuntimeException("Couldn't process property file %s", (Throwable)ex, propFile);
                }
                PropertyChainBuilder.this.logger.debug(filteredContents.toString());
                if (duplicatePrios.isEmpty()) continue;
                throw new JuRuntimeException(duplicatePrios.toString());
            }
            PropertyChainBuilder chainBuilder = PropertyChainBuilder.this;
            XString chainInfo = new XString("Evaluated property chain:");
            chainInfo.increaseIndent();
            Iterator i$ = props.keySet().iterator();
            while (i$.hasNext()) {
                int prio = (Integer)i$.next();
                chainInfo.addLine(prio + ": ");
                String[] lineParts = (String[])props.get(prio);
                String propType = lineParts[0];
                for (int i = 1; i < lineParts.length; ++i) {
                    String linePart = lineParts[i];
                    linePart = chainBuilder.peekChain().interpolate(linePart);
                    XString part = new XString(linePart);
                    for (String propertyKey : part.getPlaceHolders()) {
                        String val = chainBuilder.peekChain().get(propertyKey);
                        if (val != null) {
                            part.setPlaceholder(propertyKey, val);
                            continue;
                        }
                        PropertyChainBuilder.this.logger.debug("Couldn't replace placeholder: " + propertyKey);
                    }
                    lineParts[i] = part.toString();
                }
                if ("sys".equals(propType)) {
                    chainBuilder.addSystemPropertyEvaluator();
                    chainInfo.addText("System Properties");
                    continue;
                }
                if ("prop".equals(propType)) {
                    AssertUtil.assertTrue("prop property type must be followed by a resource path", lineParts.length > 1);
                    String resourcePath = lineParts[1];
                    boolean optional = lineParts.length > 2 && "optional".equals(lineParts[2]);
                    URL resourceUrl = PropertyChainBuilder.this.getFileResource(resourcePath, optional);
                    if (resourceUrl != null) {
                        chainBuilder.addResourcePropertyEvaluator(resourceUrl);
                        chainInfo.addText("Properties file: " + resourceUrl);
                        continue;
                    }
                    AssertUtil.assertTrue("Mandatory resource not found: " + resourcePath, optional);
                    chainInfo.addText("Properties file:   >>> optional resource not found: " + resourcePath);
                    continue;
                }
                if ("csv".equals(propType)) {
                    AssertUtil.assertTrue("prop property type must be followed by a resource path and a profile property name", lineParts.length > 2);
                    String resourcePath = lineParts[1];
                    String profilePropertyName = lineParts[2];
                    String profileName = chainBuilder.getPropertyChain().get(profilePropertyName);
                    String defaultColumn = lineParts.length > 3 ? lineParts[2] : "default";
                    URL resourceUrl = PropertyChainBuilder.this.getFileResource(resourcePath, false);
                    chainBuilder.addCsvPropertyEvaluator(resourceUrl, profileName, defaultColumn);
                    chainInfo.addFormatted("CSV Properties: %s [profileName=%s, defaultColumn=%s]", resourceUrl, profileName, defaultColumn);
                    continue;
                }
                throw new JuRuntimeException("Unsupported property type: " + propType);
            }
            PropertyChainBuilder.this.logger.info(chainInfo.toString());
            return PropertyChainBuilder.this;
        }
    }
}

