/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.JuRuntimeException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSUtils {
    private static XSystem[] xSystems = new XSystem[]{new XSystemImpl("com.sun.security.auth.module.NTSystem", "getName", "getDomain"), new XSystemImpl("com.sun.security.auth.module.UnixSystem", "getUsername", null)};

    public static String getUserName() {
        return OSUtils.getXSystem().getUserName();
    }

    public static String getDomainName() {
        return OSUtils.getXSystem().getDomainName();
    }

    private static XSystem getXSystem() {
        for (XSystem xSystem : xSystems) {
            if (!xSystem.isAvailable()) continue;
            return xSystem;
        }
        throw new JuRuntimeException("No XSystem implementation available");
    }

    private static class XSystemImpl
    implements XSystem {
        Logger logger = LoggerFactory.getLogger(XSystemImpl.class);
        private final String className;
        private final Class<?> clazz;
        private final String userNameMethodName;
        private final String domainNameMethodName;

        public XSystemImpl(String className, String userNameMethodName, String domainNameMethodName) {
            this.className = className;
            this.userNameMethodName = userNameMethodName;
            this.domainNameMethodName = domainNameMethodName;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(this.className);
            }
            catch (ClassNotFoundException ex) {
                this.logger.warn("Class not found: " + this.className);
            }
            this.clazz = clazz;
        }

        @Override
        public boolean isAvailable() {
            return this.clazz != null;
        }

        private String getValue(String methodName) {
            if (methodName == null) {
                return null;
            }
            String className = "";
            try {
                Method method = this.clazz.getMethod(methodName, new Class[0]);
                Object instance = this.clazz.newInstance();
                return (String)method.invoke(instance, new Object[0]);
            }
            catch (Exception ex) {
                throw new JuRuntimeException(String.format("Couldn't invoke method %s of %s. Make sure this is a Oracle Windows JDK.", methodName, className), ex);
            }
        }

        @Override
        public String getUserName() {
            return this.getValue(this.userNameMethodName);
        }

        @Override
        public String getDomainName() {
            return this.getValue(this.domainNameMethodName);
        }
    }

    private static interface XSystem {
        public String getUserName();

        public String getDomainName();

        public boolean isAvailable();
    }
}

