/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.security.JuSecurityUtils;
import ch.inftec.ju.security.JuTextEncryptor;
import ch.inftec.ju.util.InterpolatingPropertyChain;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.PropertyChain;
import ch.inftec.ju.util.PropertyChainBuilder;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JuUtils {
    private static Logger logger = LoggerFactory.getLogger(JuUtils.class);
    private static PropertyChain juPropertyChain;
    private static JuTextEncryptor defaultEncryptor;
    private static final String PROPERTIES_FILES_NAME = "ju.properties.files";
    private static final String ENCRYPTION_PASSWORD_PROPERTY = "ju-util.propertyChain.encryption.password";
    private static final String ENCRYPTION_PASSWORD_FILE_PROPERTY = "ju-util.propertyChain.encryption.passwordFile";
    private static final String STRONG_ENCRYPTION_PROPERTY = "ju-util.propertyChain.encryption.strong";
    private static final String INTERPOLATION_PROPERTY = "ju-util.propertyChain.interpolation";

    public static synchronized PropertyChain getJuPropertyChain() {
        if (juPropertyChain == null) {
            logger.debug("Initializing JU PropertyChain");
            PropertyChainBuilder chainBuilder = new PropertyChainBuilder();
            chainBuilder.hideValueForKey(ENCRYPTION_PASSWORD_PROPERTY);
            chainBuilder.addEvaluatorsByChainFiles().name(PROPERTIES_FILES_NAME).resolve();
            boolean interpolate = chainBuilder.peekChain().get(INTERPOLATION_PROPERTY, Boolean.class, "true");
            chainBuilder.interpolation().enable(interpolate);
            JuUtils.evaluateDefaultEncryptor(chainBuilder.peekChain());
            chainBuilder.setDecryptor(defaultEncryptor);
            juPropertyChain = chainBuilder.getPropertyChain();
        }
        return juPropertyChain;
    }

    public static void clearPropertyChain() {
        juPropertyChain = null;
        defaultEncryptor = null;
    }

    private static synchronized void evaluateDefaultEncryptor(PropertyChain chainPeek) {
        String encryptionPassword = chainPeek.get(ENCRYPTION_PASSWORD_PROPERTY);
        boolean strongEncryption = chainPeek.get(STRONG_ENCRYPTION_PROPERTY, Boolean.class, "false");
        if (StringUtils.isNotBlank((CharSequence)encryptionPassword)) {
            logger.debug("Password set, setting decryptor (strong encryption={})", (Object)strongEncryption);
            defaultEncryptor = JuSecurityUtils.buildEncryptor().strong(strongEncryption).password(encryptionPassword).createTextEncryptor();
        } else {
            String encryptionPasswordFile = chainPeek.get(ENCRYPTION_PASSWORD_FILE_PROPERTY);
            if (!StringUtils.isEmpty((CharSequence)encryptionPasswordFile)) {
                logger.debug("Password file set: {}. Loading password and setting decryptor (strong encryption={})", (Object)encryptionPasswordFile, (Object)strongEncryption);
                Path p = JuUrl.existingFile(encryptionPasswordFile);
                defaultEncryptor = JuSecurityUtils.buildEncryptor().strong(strongEncryption).passwordByUrl(JuUrl.toUrl(p)).createTextEncryptor();
            }
        }
    }

    public static synchronized JuTextEncryptor getDefaultEncryptor() {
        JuUtils.getJuPropertyChain();
        return defaultEncryptor;
    }

    public static String interpolate(String expression) {
        return JuUtils.interpolate(expression, JuUtils.getJuPropertyChain());
    }

    public static String interpolate(String expression, PropertyChain chain) {
        InterpolatingPropertyChain propertyChain = new PropertyChainBuilder().interpolation().enable(true).done().addPropertyChainPropertyEvaluator(chain).getPropertyChain();
        return propertyChain.interpolate(expression);
    }
}

