/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.libs;

import java.util.Properties;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.junit.Assert;
import org.junit.Test;

public class PlexusInterpolationTest {
    @Test
    public void testInterpolation_withoutSource() throws Exception {
        String s = "Hello ${name}";
        RegexBasedInterpolator i = new RegexBasedInterpolator();
        Assert.assertEquals((Object)"Hello ${name}", (Object)i.interpolate(s));
    }

    @Test
    public void testInterpolation_withPropertiesSource() throws Exception {
        String s = "Hello ${name}";
        Properties props = new Properties();
        props.put("name", "World");
        PropertiesBasedValueSource vs = new PropertiesBasedValueSource(props);
        RegexBasedInterpolator i = new RegexBasedInterpolator();
        i.addValueSource((ValueSource)vs);
        Assert.assertEquals((Object)"Hello World", (Object)i.interpolate(s));
    }

    @Test
    public void testInterpolation_withCustomValueSource() throws Exception {
        String s = "Hello ${name}";
        AbstractValueSource vs = new AbstractValueSource(false){

            public Object getValue(String expression) {
                return "World";
            }
        };
        RegexBasedInterpolator i = new RegexBasedInterpolator();
        i.addValueSource((ValueSource)vs);
        Assert.assertEquals((Object)"Hello World", (Object)i.interpolate(s));
    }
}

