/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.util.InterpolatingPropertyChain;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.PropertyChain;
import ch.inftec.ju.util.PropertyChainBuilder;
import ch.inftec.ju.util.SystemPropertyTempSetter;
import org.junit.Assert;
import org.junit.Test;

public class PropertyChainBuilderTest {
    @Test
    public void buildsSystemPropertyEvaluator() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addSystemPropertyEvaluator().getPropertyChain();
        String key = "ch.inftec.ju.util.PropertyChainTest.prop1";
        System.setProperty(key, "val1");
        Assert.assertEquals((Object)"val1", (Object)chain.get(key));
    }

    @Test
    public void buildsResourcePropertyEvaluator() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest.properties", false).getPropertyChain();
        Assert.assertEquals((Object)"val1", (Object)chain.get("prop1"));
    }

    @Test
    public void canBuild_propertyChain_byPropertiesFiles_onClasspath() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addEvaluatorsByChainFiles().name("ch/inftec/ju/util/propertyChain/classpathProps.files").resolve().getPropertyChain();
        Assert.assertEquals((Object)"classpathPropVal", (Object)chain.get("prop"));
    }

    @Test
    public void canBuild_propertyChain_byPropertiesFiles_onFileSystem() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addResourceFolder(JuUrl.existingFolder((String)"src/test/nonCpResources")).addEvaluatorsByChainFiles().name("ch/inftec/ju/util/propertyChain/fileSystemProps_prop.files").resolve().getPropertyChain();
        Assert.assertEquals((Object)"fileSystemPropVal", (Object)chain.get("propFs"));
        Assert.assertEquals((Object)"classpathPropVal_onFs", (Object)chain.get("propCpFs"));
        Assert.assertEquals((Object)"classpathPropVal", (Object)chain.get("propCp"));
    }

    @Test
    public void supports_SystemProperties_inPropertiesFiels() {
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("key", "tempProp");
            InterpolatingPropertyChain chain = new PropertyChainBuilder().addEvaluatorsByChainFiles().name("ch/inftec/ju/util/propertyChain/classpathProps_sys.files").resolve().getPropertyChain();
            Assert.assertEquals((Object)"tempProp", (Object)chain.get("key"));
        }
    }

    @Test
    public void canFind_resoures_inFileSystem() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addResourceFolder(JuUrl.existingFolder((String)"src/test/nonCpResources")).addEvaluatorsByChainFiles().name("ch/inftec/ju/util/propertyChain/fileSystemProps_prop.files").resolve().getPropertyChain();
        Assert.assertEquals((Object)"fileSystemPropVal", (Object)chain.get("propFs"));
    }

    @Test
    public void canAdd_listPropertyEvaluator() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addListPropertyEvaluator(new String[]{"p1", "val1"}).getPropertyChain();
        Assert.assertEquals((Object)"val1", (Object)chain.get("p1"));
    }

    @Test
    public void canAdd_propertyChainPropertyEvaluator() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addListPropertyEvaluator(new String[]{"p1", "val1"}).getPropertyChain();
        InterpolatingPropertyChain chain2 = new PropertyChainBuilder().addPropertyChainPropertyEvaluator((PropertyChain)chain).getPropertyChain();
        Assert.assertEquals((Object)"val1", (Object)chain2.get("p1"));
    }

    @Test
    public void canInterpolate_inPropertiesFile_usingPercentageSign() {
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("propKey", "interpolate");
            InterpolatingPropertyChain chain = new PropertyChainBuilder().addEvaluatorsByChainFiles().name("ch/inftec/ju/util/propertyChain/interpolatePercentageSign.files").resolve().getPropertyChain();
            Assert.assertEquals((Object)"interpolated", (Object)chain.get("key"));
        }
    }

    @Test
    public void canInterpolate_inPropertiesFile_usingDollarSign() {
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("propKey", "interpolate");
            InterpolatingPropertyChain chain = new PropertyChainBuilder().addEvaluatorsByChainFiles().name("ch/inftec/ju/util/propertyChain/interpolateDollarSign.files").resolve().getPropertyChain();
            Assert.assertEquals((Object)"interpolated", (Object)chain.get("key"));
        }
    }
}

