/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.xml;

import ch.inftec.ju.util.JuException;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.TestUtils;
import ch.inftec.ju.util.xml.XPathGetter;
import ch.inftec.ju.util.xml.XmlOutputConverter;
import ch.inftec.ju.util.xml.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.validation.Schema;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateMidnight;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlUtilsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void loadXml() throws Exception {
        Document doc = XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("simple.xml"));
        Element root = doc.getDocumentElement();
        Assert.assertEquals((Object)root.getTagName(), (Object)"root");
        Element element = (Element)root.getElementsByTagName("element").item(0);
        Assert.assertEquals((Object)element.getNodeName(), (Object)"element");
        Element childElement1 = (Element)element.getElementsByTagName("childElement").item(0);
        Assert.assertEquals((Object)childElement1.getNodeName(), (Object)"childElement");
        Node textElement = element.getElementsByTagName("textElement").item(0);
        Assert.assertEquals((Object)textElement.getTextContent(), (Object)"This is a little text");
    }

    @Test
    public void loadXml_validated() throws Exception {
        XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("simpleValidated.xml"), (URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("simple.xsd"));
    }

    @Test
    public void canValidate_validXml() throws Exception {
        String xml = "<root><childElement name=\"test\" value=\"test2\"/></root>";
        XmlUtils.validate((String)xml, (Schema)XmlUtils.loadSchema((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("simple.xsd")));
    }

    @Test
    public void validate_throwsException_onInvalidXml() throws Exception {
        this.thrown.expect(JuException.class);
        this.thrown.expectMessage("rootbla");
        String xml = "<rootbla/>";
        XmlUtils.validate((String)xml, (Schema)XmlUtils.loadSchema((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("simple.xsd")));
    }

    @Test(expected=JuException.class)
    public void loadXml_invalid() throws Exception {
        try {
            XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("simpleValidated.xml_invalid"));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.toString());
        }
        XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("simpleValidated.xml_invalid"), (URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("simple.xsd"));
    }

    private void xPathGetter(String resourceName) throws Exception {
        Document doc = XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get(resourceName));
        XPathGetter xg = new XPathGetter((Node)doc);
        Assert.assertEquals((Object)"XPathGetter[node=#document,nodeValue=<null>]", (Object)xg.toString());
        Assert.assertArrayEquals((Object[])xg.getArray("//a1/*/@text"), (Object[])new String[]{"B2", "B2", "B3"});
        Assert.assertArrayEquals((Object[])xg.getArrayLong("//*/@value"), (Object[])new Long[]{1L, 2L, 2L});
        Assert.assertArrayEquals((Object[])xg.getDistinctArray("//b3/*/@value"), (Object[])new String[]{"2"});
        Assert.assertArrayEquals((Object[])xg.getDistinctArrayLong("//b3/*/@value"), (Object[])new Long[]{2L});
        Assert.assertEquals((Object)xg.getGetter("//b3").getSingle("@text"), (Object)"B3");
        XPathGetter[] xgSubs = xg.getGetters("//b3/*");
        Assert.assertEquals((long)xgSubs.length, (long)2L);
        Assert.assertEquals((Object)xgSubs[0].getSingle("@text"), (Object)"C2");
        Assert.assertEquals((Object)"XPathGetter[node=c2,nodeValue=<null>]", (Object)xgSubs[0].toString());
        Assert.assertEquals((Object)xgSubs[1].getSingle("@text"), (Object)"C3");
        Assert.assertEquals((Object)"XPathGetter[node=c3,nodeValue=<null>]", (Object)xgSubs[1].toString());
        Assert.assertEquals((Object)xg.getNode("root"), (Object)doc.getDocumentElement());
        Node[] bNodes = xg.getNodes("//a1/*");
        Assert.assertEquals((long)bNodes.length, (long)3L);
        Assert.assertEquals((Object)bNodes[2].getNodeName(), (Object)"b3");
        Assert.assertEquals((Object)xg.getSingle("/root/a1/@text"), (Object)"A1");
        Assert.assertEquals((Object)xg.getSingleLong("/root/a1/b2/c1/@value"), (Object)new Long(1L));
        Assert.assertEquals((long)3L, (long)xg.getCount("//a1/*"));
    }

    @Test
    public void xPathGetter() throws Exception {
        this.xPathGetter("xPathGetter.xml");
    }

    @Test
    public void xPathGetter_namespace() throws Exception {
        this.xPathGetter("xPathGetter_namespace.xml");
    }

    @Test
    public void xmlTtoString() {
        Document doc = XmlUtils.buildXml((String)"root").addChild("child1").setAttribute("childAttr1", "val1").setAttribute("childAttr2", "val2").addText("Text1").endChild().addChild("child2").addChild("subChild1").addText("Text2").endChild().endChild().getDocument();
        String simpleXml = XmlUtils.toString((Document)doc, (boolean)false, (boolean)false);
        TestUtils.assertEqualsResource((String)"xmlToString_simpleXml.xml", (String)simpleXml, (String[])new String[0]);
        String fullXml = XmlUtils.toString((Document)doc, (boolean)true, (boolean)true);
        TestUtils.assertEqualsResource((String)"xmlToString_fullXml.xml", (String)fullXml, (String[])new String[0]);
    }

    @Test
    public void stringToXml() throws Exception {
        String xmlString = "<root><child>someText</child></root>";
        Document xmlDoc = XmlUtils.loadXml((String)xmlString, null);
        Assert.assertEquals((long)1L, (long)xmlDoc.getChildNodes().getLength());
        Assert.assertEquals((Object)"root", (Object)xmlDoc.getChildNodes().item(0).getNodeName());
        Assert.assertEquals((Object)xmlString, (Object)XmlUtils.toString((Document)xmlDoc, (boolean)false, (boolean)false));
    }

    @Test
    public void equalsXml() throws Exception {
        Document doc1 = XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("xmlToString_simpleXml.xml"));
        Document doc2 = XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("xmlToString_fullXml.xml"));
        TestUtils.assertEqualsXml((Document)doc1, (Document)doc2);
        Document doc3 = XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("xmlToString_fullXml_diff.xml"));
        try {
            TestUtils.assertEqualsXml((Document)doc1, (Document)doc3);
            Assert.fail((String)"XMLs are not equal");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void xmlOutputConverter() throws Exception {
        Document doc1 = XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("simpleSpecialChars.xml"));
        String xml1 = XmlUtils.toString((Document)doc1, (boolean)true, (boolean)true);
        ByteArrayInputStream is = new ByteArrayInputStream(xml1.getBytes("UTF-8"));
        XmlOutputConverter xmlConv1 = new XmlOutputConverter();
        IOUtils.copy((InputStream)is, (OutputStream)xmlConv1.getOutputStream());
        Document doc2 = xmlConv1.getDocument();
        TestUtils.assertEqualsXml((Document)doc1, (Document)doc2);
        XPathGetter xg = new XPathGetter((Node)doc1);
        Assert.assertEquals((Object)"This is a little text: \u00e4\u00f6\u00fc\u00b0+\"*\u00e7%&/()=?`\u00e8!\u00e9\u00e0\u00a3><;:_,.-", (Object)xg.getSingle("//textElement"));
    }

    @Test
    public void canHandleSpecialCharacters_inAttributes() throws Exception {
        Document doc1 = XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("simpleSpecialChars.xml"));
        XPathGetter xg = new XPathGetter((Node)doc1);
        Assert.assertEquals((Object)"This is a little attr-text: \u00e4\u00f6\u00fc\u00b0+\"*\u00e7%&/()=?`\u00e8!\u00e9\u00e0\u00a3><;:_,.-", (Object)xg.getSingle("//attrElement/@textFull"));
    }

    @Test
    public void canLookForSpecialCharacters_inXPath() throws Exception {
        Document doc1 = XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("simpleSpecialChars.xml"));
        XPathGetter xg = new XPathGetter((Node)doc1);
        Assert.assertEquals((Object)"", (Object)xg.getSingle("//attrElement[@textQuot='And ;']/textQuot"));
    }

    public void xPathGetter_canEvaluateXPath2() throws Exception {
        Document doc = XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("xPathGetter.xml"));
        XPathGetter xg = new XPathGetter((Node)doc);
        String name = xg.getSingle("root/a1/name()");
        Assert.assertEquals((Object)"a1", (Object)name);
    }

    @Test
    public void xPathGetter_reckognizesEmptyElements() throws Exception {
        Document doc = XmlUtils.loadXml((URL)JuUrl.resource().relativeTo(XmlUtilsTest.class).get("xPathGetter_emptyElement.xml"));
        XPathGetter xg = new XPathGetter((Node)doc);
        Assert.assertTrue((boolean)xg.isEmptyElement("//a1"));
        Assert.assertTrue((boolean)xg.isEmptyElement("//a5"));
        Assert.assertTrue((boolean)xg.isEmptyElement("//a6"));
        Assert.assertFalse((boolean)xg.isEmptyElement("//a2"));
        Assert.assertFalse((boolean)xg.isEmptyElement("//a4"));
    }

    @Test
    public void canConvertDate_toGregorianCalendar() {
        LocalDate lt = new LocalDate(2000, 1, 2);
        DateMidnight dm = lt.toDateMidnight(DateTimeZone.UTC);
        XMLGregorianCalendar gc = XmlUtils.asXMLGregorianCalendar((Date)dm.toDate());
        Assert.assertEquals((Object)"2000-01-02T00:00:00.000Z", (Object)gc.toXMLFormat());
    }

    @Test
    public void canConvert_GregorianCalendar_toDate() {
        LocalDate lt = new LocalDate(2000, 1, 2);
        DateMidnight dm = lt.toDateMidnight(DateTimeZone.UTC);
        Date d = dm.toDate();
        XMLGregorianCalendar gc = XmlUtils.asXMLGregorianCalendar((Date)d);
        Date dConv = XmlUtils.asDate((XMLGregorianCalendar)gc);
        Assert.assertEquals((Object)d, (Object)dConv);
    }

    @Test
    public void canBuildXml_withNamespaces() {
        Document doc = XmlUtils.buildXml((String)"test", (String)"ns1", (String)"http://inftec.ch/ns1").addNamespace("ns2", "http://inftec.ch/ns2").addChild("child").endChild().addChild("child", "ns2").addChild("child", "ns1").endChild().endChild().getDocument();
        TestUtils.assertEqualsXmlResource((String)"XmlUtilsTest_canBuildXml_withNamespaces.xml", (Document)doc);
    }
}

