/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.persistable;

import ch.inftec.ju.util.comparison.EqualityTester;
import ch.inftec.ju.util.persistable.GenericMemento;
import ch.inftec.ju.util.persistable.GenericMementoUtils;
import ch.inftec.ju.util.persistable.GenericMementoX;
import ch.inftec.ju.util.persistable.Persistable;
import ch.inftec.ju.util.persistable.TypeHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.lang3.ObjectUtils;
import org.junit.Test;

public class GenericMementoTest {
    @Test
    public void genericMementoUsage() {
        ItemEqualityTester equalityTester = new ItemEqualityTester();
        Date now = new Date();
        Date later = new Date(now.getTime() + 1000L);
        PersistableItem i1 = new PersistableItem(1L, "one", now);
        i1.addChild(new PersistableItem(2L, "two", later));
        GenericMemento memento = i1.createMemento();
        PersistableItem l1 = new PersistableItem();
        l1.setMemento(memento);
        Assert.assertTrue((boolean)equalityTester.equals(i1, l1));
    }

    @Test
    public void genericMementoX() {
        GenericMemento genericMemento = GenericMementoUtils.builder().add("key1", (Object)"val1").add("key2", (Object)"val2").build();
        GenericMementoX g = GenericMementoUtils.asX((GenericMemento)genericMemento);
        Assert.assertEquals((String)"val1", (String)g.getAttribute("key1").getStringValue());
    }

    @Test
    public void testNull() {
        GenericMementoX g = GenericMementoUtils.asX((GenericMemento)GenericMementoUtils.builder().build());
        Assert.assertEquals(null, (Object)g.getAttribute(null));
        GenericMemento genericMementoNull = GenericMementoUtils.builder().add(null, (Object)"nullVal").add("nullKey", null).build();
        GenericMementoX gNull = GenericMementoUtils.asX((GenericMemento)genericMementoNull);
        Assert.assertEquals((String)"nullVal", (String)gNull.getAttribute(null).getStringValue());
        Assert.assertNull((Object)gNull.getStringValue("nullKey"));
        Assert.assertNull((Object)gNull.getLongValue("nullKey"));
        Assert.assertNull((Object)gNull.getDateValue("nullKey"));
    }

    @Test
    public void typeHandler() {
        GenericMementoUtils.TypeHandlerBuilder builder = GenericMementoUtils.newTypeHandler();
        TypeHandler1 th1 = new TypeHandler1();
        TypeHandler2 th2 = new TypeHandler2();
        Assert.assertEquals((String)TypeHandler1.class.getName(), (String)builder.getHandler().getTypeName((Persistable)th1));
        Assert.assertEquals((String)TypeHandler2.class.getName(), (String)builder.getHandler().getTypeName((Persistable)th2));
        Assert.assertEquals(TypeHandler1.class, builder.getHandler().newInstance(TypeHandler1.class.getName()).getClass());
        builder.addMapping(TypeHandler1.class);
        Assert.assertEquals((String)TypeHandler1.class.getName(), (String)builder.getHandler().getTypeName((Persistable)th1));
        builder.addMapping(TypeHandler2.class);
        Assert.assertEquals((String)"H2", (String)builder.getHandler().getTypeName((Persistable)th2));
        Assert.assertEquals(TypeHandler2.class, builder.getHandler().newInstance("H2").getClass());
        Assert.assertEquals(TypeHandler3.class, builder.getHandler().newInstance(TypeHandler3.class.getName()).getClass());
    }

    @Test
    public void dynamicTypeHandler() {
        TypeHandler handler = GenericMementoUtils.newTypeHandler().dynamic(true).getHandler();
        Assert.assertEquals((String)TypeHandler1.class.getName(), (String)handler.getTypeName((Persistable)new TypeHandler1()));
        Assert.assertEquals((String)"H2", (String)handler.getTypeName((Persistable)new TypeHandler2()));
        Assert.assertEquals(TypeHandler2.class, handler.newInstance("H2").getClass());
    }

    private static final class TypeHandler3
    extends TypeHandler1 {
        private TypeHandler3() {
        }
    }

    static final class TypeHandler2
    extends TypeHandler1 {
        private static String MEMENTO_TYPE_NAME = "H2";

        TypeHandler2() {
        }
    }

    public static class TypeHandler1
    implements Persistable {
        public GenericMemento createMemento() {
            return null;
        }

        public void setMemento(GenericMemento memento) {
        }
    }

    private static class PersistableItem
    implements Persistable {
        long longVal;
        String stringVal;
        Date dateVal;
        List<PersistableItem> children = new ArrayList<PersistableItem>();

        PersistableItem() {
        }

        PersistableItem(long longVal, String stringVal, Date dateVal) {
            this.longVal = longVal;
            this.stringVal = stringVal;
            this.dateVal = dateVal;
        }

        void addChild(PersistableItem item) {
            this.children.add(item);
        }

        public GenericMemento createMemento() {
            GenericMementoUtils.GenericMementoBuilder builder = GenericMementoUtils.builder();
            this.buildMemento(builder);
            return builder.build();
        }

        private void buildMemento(GenericMementoUtils.GenericMementoBuilder builder) {
            builder.add("stringVal", (Object)this.stringVal).add("longVal", (Object)this.longVal).add("dateVal", (Object)this.dateVal);
            for (PersistableItem child : this.children) {
                GenericMementoUtils.GenericMementoBuilder childBuilder = builder.newChild();
                child.buildMemento(childBuilder);
                childBuilder.childDone();
            }
        }

        public void setMemento(GenericMemento memento) {
            GenericMementoX m = GenericMementoUtils.asX((GenericMemento)memento);
            this.children.clear();
            this.stringVal = m.getStringValue("stringVal");
            this.longVal = m.getLongValue("longVal");
            this.dateVal = m.getDateValue("dateVal");
            for (GenericMemento childMemento : m.getChildren()) {
                PersistableItem child = new PersistableItem();
                child.setMemento(childMemento);
                this.children.add(child);
            }
        }
    }

    private static class ItemEqualityTester
    implements EqualityTester<PersistableItem> {
        private ItemEqualityTester() {
        }

        public boolean equals(PersistableItem i1, PersistableItem i2) {
            if (i1 == i2) {
                return true;
            }
            if (i1 == null || i2 == null) {
                return false;
            }
            if (ObjectUtils.equals((Object)i1.stringVal, (Object)i2.stringVal) && ObjectUtils.equals((Object)i1.longVal, (Object)i2.longVal) && ObjectUtils.equals((Object)i1.dateVal, (Object)i2.dateVal) && i1.children.size() == i2.children.size()) {
                for (int i = 0; i < i1.children.size(); ++i) {
                    if (this.equals(i1.children.get(i), i2.children.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

