/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.helper;

import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.helper.ValueConverterFactory;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class ValueConverterTest {
    @Test
    public void returnsObject() {
        String s = "test";
        Assert.assertSame((Object)s, (Object)ValueConverterFactory.createNewValueConverter((Object)s).get());
    }

    @Test
    public void convertsObject_toString() {
        Long l = 3L;
        Assert.assertEquals((Object)"3", (Object)ValueConverterFactory.createNewValueConverter((Object)l).get(String.class));
    }

    @Test
    public void convertsNull_toNull() {
        Object l = null;
        Assert.assertNull((Object)ValueConverterFactory.createNewValueConverter(l).get(String.class));
    }

    @Test
    public void convertsStrings_inIso8601_toDate_shortForm() throws Exception {
        String date = "2014-07-28";
        Date convDate = (Date)ValueConverterFactory.createNewValueConverter((Object)date).get(Date.class);
        Assert.assertEquals((Object)JuStringUtils.DATE_FORMAT_DAYS.parse("28.07.2014"), (Object)convDate);
    }

    @Test
    public void convertsNullString_toNull_usingDate() {
        Assert.assertNull((Object)ValueConverterFactory.createNewValueConverter(null).get(Date.class));
    }
}

