/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util;

import ch.inftec.ju.security.JuSecurityUtils;
import ch.inftec.ju.security.JuTextEncryptor;
import ch.inftec.ju.util.InterpolatingPropertyChain;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.PropertyChain;
import ch.inftec.ju.util.PropertyChainBuilder;
import ch.inftec.ju.util.SystemPropertyTempSetter;
import ch.inftec.ju.util.TestUtils;
import java.util.Collection;
import java.util.Set;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PropertyChainTest {
    @Test
    public void resourcePropertyEvaluator_ignoresMissingResource() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("xyz", true).addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest.properties", true).getPropertyChain();
        Assert.assertEquals((Object)"val1", (Object)chain.get("prop1"));
    }

    @Test
    public void propertyChain_chainsEvaluators() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest-2.properties", false).addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest.properties", false).addSystemPropertyEvaluator().getPropertyChain();
        String key = "ch.inftec.ju.util.PropertyChainTest.prop1";
        System.setProperty(key, "val1");
        Assert.assertEquals((Object)"val1b", (Object)chain.get("prop1"));
        Assert.assertEquals((Object)"val1", (Object)chain.get(key));
    }

    @Test
    public void propertyChain_listsKeys() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest-2.properties", false).addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest.properties", false).addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest-3.properties", false).addCsvPropertyEvaluator(JuUrl.resource((String)"ch/inftec/ju/util/PropertyChainTest_listKeys.csv"), "", "").getPropertyChain();
        Set keys = chain.listKeys();
        TestUtils.assertCollectionEquals((Collection)keys, (Object[])new String[]{"prop1", "prop2", "prop3", "csvKey"});
    }

    @Test
    public void propertyChain_convertsInteger() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest_conversion.properties", false).getPropertyChain();
        Assert.assertEquals((Object)new Integer(1), (Object)chain.get("intProp1", Integer.class));
        Assert.assertEquals((Object)new Integer(-1), (Object)chain.get("intProp2", Integer.class));
    }

    @Test
    public void propertyChain_convertsBoolean() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest_conversion.properties", false).getPropertyChain();
        Assert.assertTrue((boolean)((Boolean)chain.get("booleanProp1", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)chain.get("booleanProp2", Boolean.class)));
    }

    @Test
    public void propertyChain_decryptsEncryptedValues() {
        JuTextEncryptor encryptor = JuSecurityUtils.buildEncryptor().password("secret").createTextEncryptor();
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest_encryption.properties", false).setDecryptor(encryptor).getPropertyChain();
        Assert.assertEquals((Object)"secret String", (Object)chain.get("encString"));
    }

    @Test
    public void propertyChain_leavesNormalValues() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest_encryption.properties", false).getPropertyChain();
        Assert.assertEquals((Object)"normal String", (Object)chain.get("normString"));
    }

    @Test
    public void propertyChain_leavesValuesIfEncryptedValIsSubstring() {
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest_encryption.properties", false).getPropertyChain();
        Assert.assertEquals((Object)"SubString ENC(bSmw4g8BdopiLClgC7zU2Kwr0LyRqj79)", (Object)chain.get("encSubString"));
    }

    @Test
    public void propertyChain_doesNotInterpolateProperty_ifDeactivated() {
        PropertyChain pc = PropertyChainTest.createPropertiesChain(false, "prop1", "World", "prop2", "Hello ${prop1}");
        Assert.assertEquals((Object)"Hello ${prop1}", (Object)pc.get("prop2"));
    }

    @Test
    public void propertyChain_canInterpolateProperty_ifActivated() {
        PropertyChain pc = PropertyChainTest.createPropertiesChain(true, "prop1", "World", "prop2", "Hello ${prop1}");
        Assert.assertEquals((Object)"Hello World", (Object)pc.get("prop2"));
    }

    @Test
    public void propertyChain_canInterpolate_multipleProperties() {
        PropertyChain pc = PropertyChainTest.createPropertiesChain(true, "p1", "P1", "p2", "P2 (${p1})", "p3", "P3 ${p1} ${p2}");
        Assert.assertEquals((Object)"P3 P1 P2 (P1)", (Object)pc.get("p3"));
    }

    @Test
    public void propertyChain_canInterpolate_propertyWithHyphen() {
        PropertyChain pc = PropertyChainTest.createPropertiesChain(true, "p1-p1", "P1", "ju-ee.junit.groups", "group", "p2", "${p1-p1} ${ju-ee.junit.groups}");
        Assert.assertEquals((Object)"P1 group", (Object)pc.get("p2"));
    }

    @Ignore(value="Couldn't get escaping working...")
    @Test
    public void propertyChain_canEscape_dollarSign() {
        PropertyChain pc = PropertyChainTest.createPropertiesChain(true, "p1", "P1", "p2", "$${p1}");
        Assert.assertEquals((Object)"${p1}", (Object)pc.get("p2"));
    }

    @Test
    public void propertyChain_canScope_withRecursiveInterpolation() {
        PropertyChain pc = PropertyChainTest.createPropertiesChain(true, "p1", "${p2}", "p2", "${p1}");
        Assert.assertEquals((Object)"${p2}", (Object)pc.get("p1"));
    }

    @Test
    public void canInterpolate_envVariable() {
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setEnv("MY_ENV", "myVal");
            PropertyChain chain = PropertyChainTest.createPropertiesChain(true, "p1", "v1 ${env.MY_ENV}");
            Assert.assertEquals((Object)"v1 myVal", (Object)chain.get("p1"));
        }
    }

    @Test
    public void propertyInfo_isNull_forNonExistingKey() {
        PropertyChain pc = PropertyChainTest.createPropertiesChain(true, "p1", "v1");
        PropertyChain.PropertyInfo pi = pc.getInfo("p2");
        Assert.assertNull((Object)pi);
    }

    @Test
    public void canGet_propertyInfo_forRegularProperty() {
        PropertyChain pc = PropertyChainTest.createPropertiesChain(true, "p1", "v1");
        PropertyChain.PropertyInfo pi = pc.getInfo("p1");
        Assert.assertEquals((Object)"p1", (Object)pi.getKey());
        Assert.assertEquals((Object)"v1", (Object)pi.getValue());
        Assert.assertEquals((Object)"v1", (Object)pi.getRawValue());
        Assert.assertEquals((Object)"v1", (Object)pi.getDisplayValue());
        Assert.assertFalse((boolean)pi.isSensitive());
        Assert.assertEquals((Object)"PropertyChainBuilder.PropertiesPropertyEvaluator[]", (Object)pi.getEvaluatorInfo());
    }

    @Test
    public void canGet_propertyInfo_forInterpolatedValue() {
        PropertyChain pc = PropertyChainTest.createPropertiesChain(true, "p1", "${p2}", "p2", "v2");
        PropertyChain.PropertyInfo pi = pc.getInfo("p1");
        Assert.assertEquals((Object)"p1", (Object)pi.getKey());
        Assert.assertEquals((Object)"v2", (Object)pi.getValue());
        Assert.assertEquals((Object)"${p2}", (Object)pi.getRawValue());
        Assert.assertEquals((Object)"v2", (Object)pi.getDisplayValue());
        Assert.assertFalse((boolean)pi.isSensitive());
        Assert.assertEquals((Object)"PropertyChainBuilder.PropertiesPropertyEvaluator[]", (Object)pi.getEvaluatorInfo());
    }

    @Test
    public void propertyChain_getPropertyInfo_forEncryptedValue() {
        JuTextEncryptor encryptor = JuSecurityUtils.buildEncryptor().password("secret").createTextEncryptor();
        InterpolatingPropertyChain chain = new PropertyChainBuilder().addResourcePropertyEvaluator("ch/inftec/ju/util/PropertyChainTest_encryption.properties", false).setDecryptor(encryptor).interpolation().enable(true).done().getPropertyChain();
        PropertyChain.PropertyInfo pi = chain.getInfo("encString");
        Assert.assertEquals((Object)"encString", (Object)pi.getKey());
        Assert.assertEquals((Object)"secret String", (Object)pi.getValue());
        Assert.assertEquals((Object)"ENC(bSmw4g8BdopiLClgC7zU2Kwr0LyRqj79)", (Object)pi.getRawValue());
        Assert.assertEquals((Object)"***", (Object)pi.getDisplayValue());
        Assert.assertTrue((boolean)pi.isSensitive());
        Assert.assertTrue((boolean)pi.getEvaluatorInfo().startsWith("PropertyChainBuilder.PropertiesPropertyEvaluator[url="));
    }

    static PropertyChain createPropertiesChain(boolean enableInterpolation, String ... keyValuePairs) {
        return new PropertyChainBuilder().addListPropertyEvaluator(keyValuePairs).interpolation().enable(enableInterpolation).done().getPropertyChain();
    }
}

