/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.libs;

import ch.inftec.ju.util.JuException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class JavaConcurrencyTest {
    private static ExecutorService executor = Executors.newSingleThreadExecutor();

    @AfterClass
    public static void shutdownExecutor() {
        executor.shutdown();
    }

    @Test
    public void futureTask_returningResult() throws Exception {
        FutureTask<String> futureTask = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "FutureTask result";
            }
        });
        executor.execute(futureTask);
        Assert.assertEquals((Object)"FutureTask result", (Object)futureTask.get());
        Assert.assertTrue((boolean)futureTask.isDone());
        Assert.assertFalse((boolean)futureTask.isCancelled());
    }

    @Test
    public void futureTask_throwingException() throws Exception {
        FutureTask<String> futureTask = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                throw new JuException("Failing...");
            }
        });
        executor.execute(futureTask);
        try {
            futureTask.get();
        }
        catch (ExecutionException ex) {
            Assert.assertEquals((Object)"Failing...", (Object)ex.getCause().getMessage());
            Assert.assertTrue((boolean)futureTask.isDone());
            Assert.assertFalse((boolean)futureTask.isCancelled());
        }
    }

    @Test
    public void futureTask_canBeCancelled() throws Exception {
        FutureTask<String> futureTask = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                while (true) {
                    // Infinite loop
                }
            }
        });
        executor.execute(futureTask);
        futureTask.cancel(true);
        Assert.assertTrue((boolean)futureTask.isDone());
        Assert.assertTrue((boolean)futureTask.isCancelled());
    }
}

