/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.security;

import ch.inftec.ju.security.JuSecurityUtils;
import ch.inftec.ju.security.JuTextEncryptor;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.RegexUtil;
import ch.inftec.ju.util.io.NewLineReader;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.junit.Assert;
import org.junit.Test;

public class JuSecurityUtilsTest {
    @Test
    public void canEncryptText_usingBasicEncryptor() {
        JuTextEncryptor encryptor = JuSecurityUtils.buildEncryptor().password("secret").createTextEncryptor();
        String encryptedString = encryptor.encrypt("String");
        Assert.assertNotNull((Object)encryptor.encrypt("String"));
        Assert.assertEquals((Object)"String", (Object)encryptor.decrypt(encryptedString));
    }

    @Test
    public void canDencryptText_usingBasicEncryptor() {
        JuTextEncryptor encryptor = JuSecurityUtils.buildEncryptor().password("secret").createTextEncryptor();
        Assert.assertEquals((Object)"String", (Object)encryptor.decrypt("8vu+etsGrzZK30MCEBjTzg=="));
    }

    @Test(expected=EncryptionOperationNotPossibleException.class)
    public void throwsException_usingBasicEncryptor_withWrongPassword() {
        JuTextEncryptor encryptor = JuSecurityUtils.buildEncryptor().password("wrongSecret").createTextEncryptor();
        Assert.assertEquals((Object)"String", (Object)encryptor.decrypt("8vu+etsGrzZK30MCEBjTzg=="));
    }

    @Test
    public void decryptTaggedValueIfNecessary_decryptsEncryptedString() {
        JuTextEncryptor encryptor = JuSecurityUtils.buildEncryptor().password("secret").createTextEncryptor();
        Assert.assertEquals((Object)"String", (Object)JuSecurityUtils.decryptTaggedValueIfNecessary((String)"ENC(8vu+etsGrzZK30MCEBjTzg==)", (JuTextEncryptor)encryptor));
    }

    @Test
    public void decryptTaggedValueIfNecessary_returnsUnencryptedString() {
        JuTextEncryptor encryptor = JuSecurityUtils.buildEncryptor().password("secret").createTextEncryptor();
        Assert.assertEquals((Object)"8vu+etsGrzZK30MCEBjTzg==", (Object)JuSecurityUtils.decryptTaggedValueIfNecessary((String)"8vu+etsGrzZK30MCEBjTzg==", (JuTextEncryptor)encryptor));
    }

    @Test
    public void decryptTaggedValueIfNecessary_returnsString_forEmptyEncrptor() {
        Assert.assertEquals((Object)"ENC(TEST)", (Object)JuSecurityUtils.decryptTaggedValueIfNecessary((String)"ENC(TEST)", null));
    }

    @Test
    public void isEncryptedByTag_returnsTrue_forEncryptedValue() {
        Assert.assertTrue((boolean)JuSecurityUtils.isEncryptedByTag((String)"ENC(xxx)"));
    }

    @Test
    public void isEncryptedByTag_returnsFalse_forUnencryptedValue() {
        Assert.assertFalse((boolean)JuSecurityUtils.isEncryptedByTag((String)"xyz"));
    }

    @Test
    public void isEncryptedByTag_returnsFalse_forNull() {
        Assert.assertFalse((boolean)JuSecurityUtils.isEncryptedByTag(null));
    }

    @Test
    public void canEncrypt_propertiesFile() throws Exception {
        URL srcProperties = JuUrl.resource((String)"ch/inftec/ju/util/security/JuSecurityUtilsTest_toBeEncrypted.properties");
        JuTextEncryptor encryptor = JuSecurityUtils.buildEncryptor().password("secret").createTextEncryptor();
        String res = JuSecurityUtils.performEncryption().propertyFile(srcProperties).encryptor(encryptor).encryptToString();
        List lines = NewLineReader.createByString((String)res).getLines();
        Assert.assertEquals((long)5L, (long)lines.size());
        Assert.assertEquals((Object)"normalProperty=Normal Value", lines.get(0));
        Assert.assertEquals((Object)"", lines.get(1));
        Assert.assertEquals((Object)"# This is my little secret file...", lines.get(2));
        Assert.assertTrue((boolean)((String)lines.get(3)).startsWith("secretProperty=ENC("));
        String encryptedVal = new RegexUtil(".*ENC\\((.*)\\)").getMatches((String)lines.get(3))[0].getGroups()[0];
        Assert.assertEquals((Object)"myPrecious", (Object)encryptor.decrypt(encryptedVal));
        Assert.assertEquals((Object)"anoterSecret=ENC(alreadyEncrypted)", lines.get(4));
    }

    @Test
    public void canEncrypt_simpleCsvFile() throws Exception {
        URL srcCsv = JuUrl.resource((String)"ch/inftec/ju/util/security/JuSecurityUtilsTest_toBeEncrypted.csv");
        JuTextEncryptor encryptor = JuSecurityUtils.buildEncryptor().password("secret").createTextEncryptor();
        String res = JuSecurityUtils.performEncryption().csvFile(srcCsv).encryptor(encryptor).encryptToString();
        List lines = NewLineReader.createByString((String)res).getLines();
        Assert.assertEquals((long)4L, (long)lines.size());
        Assert.assertEquals((Object)"Col1;Col2;Col3", lines.get(0));
        Assert.assertEquals((Object)";Normal Value;", lines.get(1));
        Assert.assertEquals((Object)";;", lines.get(2));
        Assert.assertTrue((boolean)((String)lines.get(3)).startsWith("#Come Comment;ENC(alreadyEncrypted);"));
        String encryptedVal = new RegexUtil(".*ENC\\((.*)\\)$").getMatches((String)lines.get(3))[0].getGroups()[0];
        Assert.assertEquals((Object)"myPrecious", (Object)encryptor.decrypt(encryptedVal));
    }

    @Test
    public void canEncrypt_complexCsvFile() throws Exception {
        URL srcCsv = JuUrl.resource((String)"ch/inftec/ju/util/security/JuSecurityUtilsTest_toBeEncrypted_complex.csv");
        JuTextEncryptor encryptor = JuSecurityUtils.buildEncryptor().password("secret").createTextEncryptor();
        String res = JuSecurityUtils.performEncryption().csvFile(srcCsv).encryptor(encryptor).encryptToString();
        List lines = NewLineReader.createByString((String)res).getLines();
        Assert.assertEquals((long)3L, (long)lines.size());
        Assert.assertEquals((Object)"NormalValue;", lines.get(0));
        Assert.assertTrue((boolean)((String)lines.get(1)).startsWith("\"ENC("));
        Assert.assertTrue((boolean)((String)lines.get(1)).endsWith(")\";another value"));
        String encryptedVal1 = new RegexUtil("\"ENC\\((.*)\\)").getMatches((String)lines.get(1))[0].getGroups()[0];
        Assert.assertEquals((Object)"secret(;)", (Object)encryptor.decrypt(encryptedVal1));
        Assert.assertTrue((boolean)((String)lines.get(2)).startsWith("\"ENC("));
        Assert.assertTrue((boolean)((String)lines.get(2)).endsWith(")\";"));
        String encryptedVal2 = new RegexUtil("\"ENC\\((.*)\\)").getMatches((String)lines.get(2))[0].getGroups()[0];
        Assert.assertEquals((Object)"\"secret;\"", (Object)encryptor.decrypt(encryptedVal2));
    }

    @Test
    public void canEncrypt_toSourceFile() throws Exception {
        Path srcFile = Paths.get("src/test/resources/ch/inftec/ju/util/security/JuSecurityUtilsTest_toBeEncrypted.properties", new String[0]);
        Path testCopy = Paths.get("target/tests", new String[0]).resolve(srcFile.getFileName());
        IOUtil.copyFile((Path)srcFile, (Path)testCopy, (boolean)true);
        JuTextEncryptor encryptor = JuSecurityUtils.buildEncryptor().password("secret").createTextEncryptor();
        JuSecurityUtils.performEncryption().propertyFile(JuUrl.toUrl((Path)testCopy)).encryptor(encryptor).encryptToSourceFile();
        String res = new IOUtil().loadTextFromUrl(JuUrl.toUrl((Path)testCopy), new String[0]);
        Assert.assertFalse((boolean)res.contains("doENC("));
        IOUtil.deleteFile((Path)testCopy);
    }

    @Test
    public void canEncrypt_toSourceFile_withBackup() throws Exception {
        Path srcFile = Paths.get("src/test/resources/ch/inftec/ju/util/security/JuSecurityUtilsTest_toBeEncrypted.properties", new String[0]);
        String original = new IOUtil().loadTextFromUrl(JuUrl.toUrl((Path)srcFile), new String[0]);
        Path testCopy = Paths.get("target/tests", new String[0]).resolve(srcFile.getFileName());
        IOUtil.copyFile((Path)srcFile, (Path)testCopy, (boolean)true);
        JuTextEncryptor encryptor = JuSecurityUtils.buildEncryptor().password("secret").createTextEncryptor();
        Path backupFile = JuSecurityUtils.performEncryption().propertyFile(JuUrl.toUrl((Path)testCopy)).encryptor(encryptor).encryptToSourceFileWithBackup();
        String res = new IOUtil().loadTextFromUrl(JuUrl.toUrl((Path)testCopy), new String[0]);
        Assert.assertFalse((boolean)res.contains("doENC("));
        String backup = new IOUtil().loadTextFromUrl(JuUrl.toUrl((Path)backupFile), new String[0]);
        Assert.assertEquals((Object)original, (Object)backup);
        IOUtil.deleteFile((Path)testCopy);
        IOUtil.deleteFile((Path)backupFile);
    }
}

