/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.libs;

import ch.inftec.ju.util.JuCollectionUtils;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.collections15.ListUtils;
import org.apache.commons.collections15.bidimap.DualHashBidiMap;
import org.junit.Test;

public class CollectionsLibTest {
    @Test
    public void unmodifiableList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        List l = ListUtils.unmodifiableList(list);
        try {
            l.add(3);
            Assert.fail((String)"Could modify unmodifiable list.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void bidiMap() {
        DualHashBidiMap m = new DualHashBidiMap();
        m.put((Object)1, (Object)"one");
        m.put((Object)2, (Object)"two");
        Assert.assertEquals((String)"one", (String)((String)m.get((Object)1)));
        Assert.assertEquals((String)"two", (String)((String)m.get((Object)2)));
        Assert.assertEquals((Object)new Integer(1), (Object)m.getKey((Object)"one"));
        Assert.assertEquals((Object)new Integer(2), (Object)m.getKey((Object)"two"));
        m.put((Object)1, (Object)"1");
        Assert.assertEquals((String)"1", (String)((String)m.get((Object)1)));
        Assert.assertEquals((Object)new Integer(1), (Object)m.getKey((Object)"1"));
        Assert.assertNull((Object)m.getKey((Object)"one"));
        m.put((Object)3, (Object)"two");
        Assert.assertEquals((Object)new Integer(3), (Object)m.getKey((Object)"two"));
        Assert.assertNull((Object)m.get((Object)2));
    }

    @Test
    public void arrayList() {
        ArrayList<String> l = new ArrayList<String>();
        String s1 = "TestString";
        String s2 = "Test" + "String";
        Assert.assertNotSame((Object)s1, (Object)s2);
        l.add(s1);
        Assert.assertTrue((boolean)l.contains(s2));
        l.add(s2);
        Assert.assertEquals((int)2, (int)l.size());
        l.remove(s1);
        Assert.assertEquals((int)1, (int)l.size());
        l.add(s2);
        l.removeAll(JuCollectionUtils.arrayList((Object[])new String[]{s1}));
        Assert.assertTrue((boolean)l.isEmpty());
        l.add(s1);
        l.add(s1);
        l.add("bla");
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).equals(s1)) continue;
            iter.remove();
        }
        Assert.assertEquals((int)1, (int)l.size());
        try {
            iter = l.iterator();
            while (iter.hasNext()) {
                if (l.size() == 1) {
                    l.add("Test");
                }
                iter.next();
                Assert.fail((String)"Should throw ConcurrentModificationException");
            }
        }
        catch (ConcurrentModificationException iter2) {
            // empty catch block
        }
        l.clear();
        l.add("Test");
        l.add("Test2");
        Iterator i = l.iterator();
        i.hasNext();
        i.next();
        i.hasNext();
        i.remove();
        Assert.assertEquals((int)1, (int)l.size());
        Assert.assertEquals((String)"Test2", (String)((String)l.get(0)));
    }
}

