/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.concurrent;

import ch.inftec.ju.util.concurrent.ConcurrencyUtils;
import com.google.common.base.Predicate;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ConcurrencyUtilsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void waitFor_returnsTrue_forSuccessfulPolling() {
        TestingPredicate tp = new TestingPredicate(5);
        boolean res = ConcurrencyUtils.waitFor((Predicate)tp);
        Assert.assertTrue((boolean)res);
        Assert.assertEquals((long)5L, (long)tp.callCnt);
    }

    @Test
    public void waitFor_returnsFalse_forUnsuccessfulPolling() {
        TestingPredicate tp = new TestingPredicate(0);
        boolean res = ConcurrencyUtils.waitFor((Predicate)tp, (Duration)Duration.millis((long)10L), (Duration)Duration.millis((long)100L));
        Assert.assertFalse((boolean)res);
        Assert.assertTrue((tp.callCnt > 2 ? 1 : 0) != 0);
    }

    @Test
    public void waitFor_throwsException_forPredicateThrowingException() {
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("Failure");
        ConcurrencyUtils.waitFor((Predicate)new Predicate<Void>(){

            public boolean apply(Void input) {
                throw new RuntimeException("Failure");
            }
        }, (Duration)Duration.millis((long)10L), (Duration)Duration.standardSeconds((long)1L));
    }

    private static class TestingPredicate
    implements Predicate<Void> {
        private final int trueAfterCnt;
        private int callCnt;

        private TestingPredicate(int trueAfterCnt) {
            this.trueAfterCnt = trueAfterCnt;
        }

        public boolean apply(Void input) {
            ++this.callCnt;
            return this.trueAfterCnt > 0 && this.callCnt >= this.trueAfterCnt;
        }
    }
}

